/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractPopupPanel;

/**
 *  JSF component class
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIPopupPanel extends AbstractPopupPanel
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.PopupPanel";

    public static final String COMPONENT_FAMILY="org.richfaces.PopupPanel";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIPopupPanel() {
        super();
        setRendererType("org.richfaces.PopupPanelRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "maskmouseout",
        "maskmousedown",
        "resize",
        "maskclick",
        "beforeshow",
        "maskcontextmenu",
        "beforehide",
        "hide",
        "show",
        "maskmouseover",
        "maskmouseup",
        "maskmousemove",
        "move",
        "maskdblclick"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        autosized,
        controlsClass,
        domElementAttachment,
        followByScroll,
        header,
        headerClass,
        height,
        keepVisualState,
        left,
        maxHeight,
        maxWidth,
        minHeight,
        minWidth,
        modal,
        moveable,
        onbeforehide,
        onbeforeshow,
        onhide,
        onmaskclick,
        onmaskcontextmenu,
        onmaskdblclick,
        onmaskmousedown,
        onmaskmousemove,
        onmaskmouseout,
        onmaskmouseover,
        onmaskmouseup,
        onmove,
        onresize,
        onshow,
        overlapEmbedObjects,
        resizeable,
        shadowDepth,
        shadowOpacity,
        show,
        top,
        trimOverlayedElements,
        visualOptions,
        width,
        zIndex

    }


 
    public boolean isAutosized() {
        return Boolean.valueOf(getStateHelper().eval(Properties.autosized, false).toString());
    }
    
    public void setAutosized(boolean autosized) {
        getStateHelper().put(Properties.autosized, autosized);
    }

 
    public String getControlsClass() {
        return (String) getStateHelper().eval(Properties.controlsClass);
    }
    
    public void setControlsClass(String controlsClass) {
        getStateHelper().put(Properties.controlsClass, controlsClass);
    }

 
    public String getDomElementAttachment() {
        return (String) getStateHelper().eval(Properties.domElementAttachment);
    }
    
    public void setDomElementAttachment(String domElementAttachment) {
        getStateHelper().put(Properties.domElementAttachment, domElementAttachment);
    }

 
    public boolean isFollowByScroll() {
        return Boolean.valueOf(getStateHelper().eval(Properties.followByScroll, true).toString());
    }
    
    public void setFollowByScroll(boolean followByScroll) {
        getStateHelper().put(Properties.followByScroll, followByScroll);
    }

 
    public String getHeader() {
        return (String) getStateHelper().eval(Properties.header);
    }
    
    public void setHeader(String header) {
        getStateHelper().put(Properties.header, header);
    }

 
    public String getHeaderClass() {
        return (String) getStateHelper().eval(Properties.headerClass);
    }
    
    public void setHeaderClass(String headerClass) {
        getStateHelper().put(Properties.headerClass, headerClass);
    }

 
    public int getHeight() {
        return (Integer) getStateHelper().eval(Properties.height, -1);
    }
    
    public void setHeight(int height) {
        getStateHelper().put(Properties.height, height);
    }

 
    public boolean isKeepVisualState() {
        return Boolean.valueOf(getStateHelper().eval(Properties.keepVisualState, false).toString());
    }
    
    public void setKeepVisualState(boolean keepVisualState) {
        getStateHelper().put(Properties.keepVisualState, keepVisualState);
    }

 
    public String getLeft() {
        return (String) getStateHelper().eval(Properties.left, "auto");
    }
    
    public void setLeft(String left) {
        getStateHelper().put(Properties.left, left);
    }

 
    public int getMaxHeight() {
        return (Integer) getStateHelper().eval(Properties.maxHeight, 2147483647);
    }
    
    public void setMaxHeight(int maxHeight) {
        getStateHelper().put(Properties.maxHeight, maxHeight);
    }

 
    public int getMaxWidth() {
        return (Integer) getStateHelper().eval(Properties.maxWidth, 2147483647);
    }
    
    public void setMaxWidth(int maxWidth) {
        getStateHelper().put(Properties.maxWidth, maxWidth);
    }

 
    public int getMinHeight() {
        return (Integer) getStateHelper().eval(Properties.minHeight, -1);
    }
    
    public void setMinHeight(int minHeight) {
        getStateHelper().put(Properties.minHeight, minHeight);
    }

 
    public int getMinWidth() {
        return (Integer) getStateHelper().eval(Properties.minWidth, -1);
    }
    
    public void setMinWidth(int minWidth) {
        getStateHelper().put(Properties.minWidth, minWidth);
    }

 
    public boolean isModal() {
        return Boolean.valueOf(getStateHelper().eval(Properties.modal, true).toString());
    }
    
    public void setModal(boolean modal) {
        getStateHelper().put(Properties.modal, modal);
    }

 
    public boolean isMoveable() {
        return Boolean.valueOf(getStateHelper().eval(Properties.moveable, true).toString());
    }
    
    public void setMoveable(boolean moveable) {
        getStateHelper().put(Properties.moveable, moveable);
    }

 
    public String getOnbeforehide() {
        return (String) getStateHelper().eval(Properties.onbeforehide);
    }
    
    public void setOnbeforehide(String onbeforehide) {
        getStateHelper().put(Properties.onbeforehide, onbeforehide);
    }

 
    public String getOnbeforeshow() {
        return (String) getStateHelper().eval(Properties.onbeforeshow);
    }
    
    public void setOnbeforeshow(String onbeforeshow) {
        getStateHelper().put(Properties.onbeforeshow, onbeforeshow);
    }

 
    public String getOnhide() {
        return (String) getStateHelper().eval(Properties.onhide);
    }
    
    public void setOnhide(String onhide) {
        getStateHelper().put(Properties.onhide, onhide);
    }

 
    public String getOnmaskclick() {
        return (String) getStateHelper().eval(Properties.onmaskclick);
    }
    
    public void setOnmaskclick(String onmaskclick) {
        getStateHelper().put(Properties.onmaskclick, onmaskclick);
    }

 
    public String getOnmaskcontextmenu() {
        return (String) getStateHelper().eval(Properties.onmaskcontextmenu);
    }
    
    public void setOnmaskcontextmenu(String onmaskcontextmenu) {
        getStateHelper().put(Properties.onmaskcontextmenu, onmaskcontextmenu);
    }

 
    public String getOnmaskdblclick() {
        return (String) getStateHelper().eval(Properties.onmaskdblclick);
    }
    
    public void setOnmaskdblclick(String onmaskdblclick) {
        getStateHelper().put(Properties.onmaskdblclick, onmaskdblclick);
    }

 
    public String getOnmaskmousedown() {
        return (String) getStateHelper().eval(Properties.onmaskmousedown);
    }
    
    public void setOnmaskmousedown(String onmaskmousedown) {
        getStateHelper().put(Properties.onmaskmousedown, onmaskmousedown);
    }

 
    public String getOnmaskmousemove() {
        return (String) getStateHelper().eval(Properties.onmaskmousemove);
    }
    
    public void setOnmaskmousemove(String onmaskmousemove) {
        getStateHelper().put(Properties.onmaskmousemove, onmaskmousemove);
    }

 
    public String getOnmaskmouseout() {
        return (String) getStateHelper().eval(Properties.onmaskmouseout);
    }
    
    public void setOnmaskmouseout(String onmaskmouseout) {
        getStateHelper().put(Properties.onmaskmouseout, onmaskmouseout);
    }

 
    public String getOnmaskmouseover() {
        return (String) getStateHelper().eval(Properties.onmaskmouseover);
    }
    
    public void setOnmaskmouseover(String onmaskmouseover) {
        getStateHelper().put(Properties.onmaskmouseover, onmaskmouseover);
    }

 
    public String getOnmaskmouseup() {
        return (String) getStateHelper().eval(Properties.onmaskmouseup);
    }
    
    public void setOnmaskmouseup(String onmaskmouseup) {
        getStateHelper().put(Properties.onmaskmouseup, onmaskmouseup);
    }

 
    public String getOnmove() {
        return (String) getStateHelper().eval(Properties.onmove);
    }
    
    public void setOnmove(String onmove) {
        getStateHelper().put(Properties.onmove, onmove);
    }

 
    public String getOnresize() {
        return (String) getStateHelper().eval(Properties.onresize);
    }
    
    public void setOnresize(String onresize) {
        getStateHelper().put(Properties.onresize, onresize);
    }

 
    public String getOnshow() {
        return (String) getStateHelper().eval(Properties.onshow);
    }
    
    public void setOnshow(String onshow) {
        getStateHelper().put(Properties.onshow, onshow);
    }

 
    public boolean isOverlapEmbedObjects() {
        return Boolean.valueOf(getStateHelper().eval(Properties.overlapEmbedObjects, false).toString());
    }
    
    public void setOverlapEmbedObjects(boolean overlapEmbedObjects) {
        getStateHelper().put(Properties.overlapEmbedObjects, overlapEmbedObjects);
    }

 
    public boolean isResizeable() {
        return Boolean.valueOf(getStateHelper().eval(Properties.resizeable, false).toString());
    }
    
    public void setResizeable(boolean resizeable) {
        getStateHelper().put(Properties.resizeable, resizeable);
    }

 
    public String getShadowDepth() {
        return (String) getStateHelper().eval(Properties.shadowDepth);
    }
    
    public void setShadowDepth(String shadowDepth) {
        getStateHelper().put(Properties.shadowDepth, shadowDepth);
    }

 
    public String getShadowOpacity() {
        return (String) getStateHelper().eval(Properties.shadowOpacity);
    }
    
    public void setShadowOpacity(String shadowOpacity) {
        getStateHelper().put(Properties.shadowOpacity, shadowOpacity);
    }

 
    public boolean isShow() {
        return Boolean.valueOf(getStateHelper().eval(Properties.show, false).toString());
    }
    
    public void setShow(boolean show) {
        getStateHelper().put(Properties.show, show);
    }

 
    public String getTop() {
        return (String) getStateHelper().eval(Properties.top, "auto");
    }
    
    public void setTop(String top) {
        getStateHelper().put(Properties.top, top);
    }

 
    public boolean isTrimOverlayedElements() {
        return Boolean.valueOf(getStateHelper().eval(Properties.trimOverlayedElements, false).toString());
    }
    
    public void setTrimOverlayedElements(boolean trimOverlayedElements) {
        getStateHelper().put(Properties.trimOverlayedElements, trimOverlayedElements);
    }

 
    public String getVisualOptions() {
        return (String) getStateHelper().eval(Properties.visualOptions);
    }
    
    public void setVisualOptions(String visualOptions) {
        getStateHelper().put(Properties.visualOptions, visualOptions);
    }

 
    public int getWidth() {
        return (Integer) getStateHelper().eval(Properties.width, -1);
    }
    
    public void setWidth(int width) {
        getStateHelper().put(Properties.width, width);
    }

 
    public int getZIndex() {
        return (Integer) getStateHelper().eval(Properties.zIndex, 100);
    }
    
    public void setZIndex(int zIndex) {
        getStateHelper().put(Properties.zIndex, zIndex);
    }

}