/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractProgressBar;

/**
 *  Class provides base component class for progress bar
 
 @author "Andrey Markavtsov"
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIProgressBar extends AbstractProgressBar
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.ProgressBar";

    public static final String COMPONENT_FAMILY="org.richfaces.ProgressBar";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIProgressBar() {
        super();
        setRendererType("org.richfaces.ProgressBarRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "beforedomupdate",
        "mousedown",
        "dblclick",
        "complete",
        "click",
        "mouseover",
        "submit",
        "mousemove",
        "mouseout",
        "mouseup"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        completeClass,
        data,
        enabled,
        finishClass,
        focus,
        initialClass,
        interval,
        label,
        maxValue,
        minValue,
        mode,
        onbeforedomupdate,
        onclick,
        oncomplete,
        ondblclick,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onsubmit,
        parameters,
        reRenderAfterComplete,
        remainClass,
        value

    }


 
    public String getCompleteClass() {
        return (String) getStateHelper().eval(Properties.completeClass);
    }
    
    public void setCompleteClass(String completeClass) {
        getStateHelper().put(Properties.completeClass, completeClass);
    }

 
    public Object getData() {
        return (Object) getStateHelper().eval(Properties.data);
    }
    
    public void setData(Object data) {
        getStateHelper().put(Properties.data, data);
    }

 
    public boolean isEnabled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.enabled, false).toString());
    }
    
    public void setEnabled(boolean enabled) {
        getStateHelper().put(Properties.enabled, enabled);
    }

 
    public String getFinishClass() {
        return (String) getStateHelper().eval(Properties.finishClass);
    }
    
    public void setFinishClass(String finishClass) {
        getStateHelper().put(Properties.finishClass, finishClass);
    }

 
    public String getFocus() {
        return (String) getStateHelper().eval(Properties.focus);
    }
    
    public void setFocus(String focus) {
        getStateHelper().put(Properties.focus, focus);
    }

 
    public String getInitialClass() {
        return (String) getStateHelper().eval(Properties.initialClass);
    }
    
    public void setInitialClass(String initialClass) {
        getStateHelper().put(Properties.initialClass, initialClass);
    }

 
    public int getInterval() {
        return (Integer) getStateHelper().eval(Properties.interval, 1000);
    }
    
    public void setInterval(int interval) {
        getStateHelper().put(Properties.interval, interval);
    }

 
    public String getLabel() {
        return (String) getStateHelper().eval(Properties.label);
    }
    
    public void setLabel(String label) {
        getStateHelper().put(Properties.label, label);
    }

 
    public int getMaxValue() {
        return (Integer) getStateHelper().eval(Properties.maxValue, Integer.MIN_VALUE);
    }
    
    public void setMaxValue(int maxValue) {
        getStateHelper().put(Properties.maxValue, maxValue);
    }

 
    public int getMinValue() {
        return (Integer) getStateHelper().eval(Properties.minValue, Integer.MIN_VALUE);
    }
    
    public void setMinValue(int minValue) {
        getStateHelper().put(Properties.minValue, minValue);
    }

 
    public String getMode() {
        return (String) getStateHelper().eval(Properties.mode);
    }
    
    public void setMode(String mode) {
        getStateHelper().put(Properties.mode, mode);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnsubmit() {
        return (String) getStateHelper().eval(Properties.onsubmit);
    }
    
    public void setOnsubmit(String onsubmit) {
        getStateHelper().put(Properties.onsubmit, onsubmit);
    }

 
    public Object getParameters() {
        return (Object) getStateHelper().eval(Properties.parameters);
    }
    
    public void setParameters(Object parameters) {
        getStateHelper().put(Properties.parameters, parameters);
    }

 
    public String getReRenderAfterComplete() {
        return (String) getStateHelper().eval(Properties.reRenderAfterComplete);
    }
    
    public void setReRenderAfterComplete(String reRenderAfterComplete) {
        getStateHelper().put(Properties.reRenderAfterComplete, reRenderAfterComplete);
    }

 
    public String getRemainClass() {
        return (String) getStateHelper().eval(Properties.remainClass);
    }
    
    public void setRemainClass(String remainClass) {
        getStateHelper().put(Properties.remainClass, remainClass);
    }

 
    public Object getValue() {
        return (Object) getStateHelper().eval(Properties.value);
    }
    
    public void setValue(Object value) {
        getStateHelper().put(Properties.value, value);
    }

}