/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractPush;
import javax.el.MethodExpression;

/**
 *  Component for periodically call AJAX events on server ( poll actions )
 @author shura


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIPush extends AbstractPush
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.Push";

    public static final String COMPONENT_FAMILY="org.richfaces.Push";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIPush() {
        super();
        setRendererType("org.richfaces.PushRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "beforedomupdate",
        "complete",
        "begin",
        "dataAvailable"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "dataAvailable";
    }

    protected static enum Properties {
        bypassUpdates,
        enabled,
        eventProducer,
        interval,
        onbeforedomupdate,
        onbegin,
        oncomplete,
        ondataavailable

    }


 
    public boolean isBypassUpdates() {
        return Boolean.valueOf(getStateHelper().eval(Properties.bypassUpdates, false).toString());
    }
    
    public void setBypassUpdates(boolean bypassUpdates) {
        getStateHelper().put(Properties.bypassUpdates, bypassUpdates);
    }

 
    public boolean isEnabled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.enabled, true).toString());
    }
    
    public void setEnabled(boolean enabled) {
        getStateHelper().put(Properties.enabled, enabled);
    }

 
    public javax.el.MethodExpression getEventProducer() {
        return (MethodExpression) getStateHelper().get(Properties.eventProducer);
    }
    
    public void setEventProducer(javax.el.MethodExpression eventProducer) {
        getStateHelper().put(Properties.eventProducer, eventProducer);
    }

 
    public int getInterval() {
        return (Integer) getStateHelper().eval(Properties.interval, 1000);
    }
    
    public void setInterval(int interval) {
        getStateHelper().put(Properties.interval, interval);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        return (String) getStateHelper().eval(Properties.onbegin);
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOndataavailable() {
        return (String) getStateHelper().eval(Properties.ondataavailable);
    }
    
    public void setOndataavailable(String ondataavailable) {
        getStateHelper().put(Properties.ondataavailable, ondataavailable);
    }

}