/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractQueue;

/**
 *  @author Nick Belaevski
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIQueue extends AbstractQueue
        {

    public static final String COMPONENT_TYPE="org.richfaces.Queue";

    public static final String COMPONENT_FAMILY="org.richfaces.Queue";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIQueue() {
        super();
        setRendererType("org.richfaces.QueueRenderer");
    }



    protected static enum Properties {
        ignoreDupResponses,
        name,
        onbeforedomupdate,
        oncomplete,
        onerror,
        onevent,
        onrequestdequeue,
        onrequestqueue,
        onsubmit,
        requestDelay,
        status,
        timeout

    }


 
    public boolean isIgnoreDupResponses() {
        return Boolean.valueOf(getStateHelper().eval(Properties.ignoreDupResponses, false).toString());
    }
    
    public void setIgnoreDupResponses(boolean ignoreDupResponses) {
        getStateHelper().put(Properties.ignoreDupResponses, ignoreDupResponses);
    }

 
    public String getName() {
        return (String) getStateHelper().eval(Properties.name);
    }
    
    public void setName(String name) {
        getStateHelper().put(Properties.name, name);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOnerror() {
        return (String) getStateHelper().eval(Properties.onerror);
    }
    
    public void setOnerror(String onerror) {
        getStateHelper().put(Properties.onerror, onerror);
    }

 
    public String getOnevent() {
        return (String) getStateHelper().eval(Properties.onevent);
    }
    
    public void setOnevent(String onevent) {
        getStateHelper().put(Properties.onevent, onevent);
    }

 
    public String getOnrequestdequeue() {
        return (String) getStateHelper().eval(Properties.onrequestdequeue);
    }
    
    public void setOnrequestdequeue(String onrequestdequeue) {
        getStateHelper().put(Properties.onrequestdequeue, onrequestdequeue);
    }

 
    public String getOnrequestqueue() {
        return (String) getStateHelper().eval(Properties.onrequestqueue);
    }
    
    public void setOnrequestqueue(String onrequestqueue) {
        getStateHelper().put(Properties.onrequestqueue, onrequestqueue);
    }

 
    public String getOnsubmit() {
        return (String) getStateHelper().eval(Properties.onsubmit);
    }
    
    public void setOnsubmit(String onsubmit) {
        getStateHelper().put(Properties.onsubmit, onsubmit);
    }

 
    public int getRequestDelay() {
        return (Integer) getStateHelper().eval(Properties.requestDelay, Integer.MIN_VALUE);
    }
    
    public void setRequestDelay(int requestDelay) {
        getStateHelper().put(Properties.requestDelay, requestDelay);
    }

 
    public String getStatus() {
        return (String) getStateHelper().eval(Properties.status);
    }
    
    public void setStatus(String status) {
        getStateHelper().put(Properties.status, status);
    }

 
    public int getTimeout() {
        return (Integer) getStateHelper().eval(Properties.timeout, Integer.MIN_VALUE);
    }
    
    public void setTimeout(int timeout) {
        getStateHelper().put(Properties.timeout, timeout);
    }

}