/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractSubTableToggleControl;

/**
 *  @author Anton Belevich


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UISubTableToggleControl extends AbstractSubTableToggleControl
        {

    public static final String COMPONENT_TYPE="org.richfaces.SubTableToggleControl";

    public static final String COMPONENT_FAMILY="org.richfaces.SubTableToggleControl";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UISubTableToggleControl() {
        super();
        setRendererType("org.richfaces.SubTableToggleControlRenderer");
    }



    protected static enum Properties {
        collapseIcon,
        collapseLabel,
        event,
        expandIcon,
        expandLabel

    }


 
    public String getCollapseIcon() {
        return (String) getStateHelper().eval(Properties.collapseIcon);
    }
    
    public void setCollapseIcon(String collapseIcon) {
        getStateHelper().put(Properties.collapseIcon, collapseIcon);
    }

 
    public String getCollapseLabel() {
        return (String) getStateHelper().eval(Properties.collapseLabel);
    }
    
    public void setCollapseLabel(String collapseLabel) {
        getStateHelper().put(Properties.collapseLabel, collapseLabel);
    }

 
    public String getEvent() {
        return (String) getStateHelper().eval(Properties.event, "onclick");
    }
    
    public void setEvent(String event) {
        getStateHelper().put(Properties.event, event);
    }

 
    public String getExpandIcon() {
        return (String) getStateHelper().eval(Properties.expandIcon);
    }
    
    public void setExpandIcon(String expandIcon) {
        getStateHelper().put(Properties.expandIcon, expandIcon);
    }

 
    public String getExpandLabel() {
        return (String) getStateHelper().eval(Properties.expandLabel);
    }
    
    public void setExpandLabel(String expandLabel) {
        getStateHelper().put(Properties.expandLabel, expandLabel);
    }

}