/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import javax.faces.component.UIInput;
import org.richfaces.component.InputNumberSliderInputPosition;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class HtmlInputNumberSlider extends UIInput
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.InputNumberSlider";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlInputNumberSlider() {
        super();
        setRendererType("org.richfaces.InputNumberSliderRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "change"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }

    protected static enum Properties {
        accesskey,
        decreaseClass,
        decreaseSelectedClass,
        delay,
        disabled,
        enableManualInput,
        handleClass,
        handleSelectedClass,
        increaseClass,
        increaseSelectedClass,
        inputClass,
        inputPosition,
        inputSize,
        maxValue,
        maxlength,
        minValue,
        onchange,
        showArrows,
        showBoundaryValues,
        showInput,
        showToolTip,
        step,
        style,
        styleClass,
        tabindex,
        toolTipClass,
        trackClass

    }


 
    public String getAccesskey() {
        return (String) getStateHelper().eval(Properties.accesskey);
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
    }

 
    public String getDecreaseClass() {
        return (String) getStateHelper().eval(Properties.decreaseClass);
    }
    
    public void setDecreaseClass(String decreaseClass) {
        getStateHelper().put(Properties.decreaseClass, decreaseClass);
    }

 
    public String getDecreaseSelectedClass() {
        return (String) getStateHelper().eval(Properties.decreaseSelectedClass);
    }
    
    public void setDecreaseSelectedClass(String decreaseSelectedClass) {
        getStateHelper().put(Properties.decreaseSelectedClass, decreaseSelectedClass);
    }

 
    public int getDelay() {
        return (Integer) getStateHelper().eval(Properties.delay, 200);
    }
    
    public void setDelay(int delay) {
        getStateHelper().put(Properties.delay, delay);
    }

 
    public boolean isDisabled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.disabled, false).toString());
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public boolean isEnableManualInput() {
        return Boolean.valueOf(getStateHelper().eval(Properties.enableManualInput, true).toString());
    }
    
    public void setEnableManualInput(boolean enableManualInput) {
        getStateHelper().put(Properties.enableManualInput, enableManualInput);
    }

 
    public String getHandleClass() {
        return (String) getStateHelper().eval(Properties.handleClass);
    }
    
    public void setHandleClass(String handleClass) {
        getStateHelper().put(Properties.handleClass, handleClass);
    }

 
    public String getHandleSelectedClass() {
        return (String) getStateHelper().eval(Properties.handleSelectedClass);
    }
    
    public void setHandleSelectedClass(String handleSelectedClass) {
        getStateHelper().put(Properties.handleSelectedClass, handleSelectedClass);
    }

 
    public String getIncreaseClass() {
        return (String) getStateHelper().eval(Properties.increaseClass);
    }
    
    public void setIncreaseClass(String increaseClass) {
        getStateHelper().put(Properties.increaseClass, increaseClass);
    }

 
    public String getIncreaseSelectedClass() {
        return (String) getStateHelper().eval(Properties.increaseSelectedClass);
    }
    
    public void setIncreaseSelectedClass(String increaseSelectedClass) {
        getStateHelper().put(Properties.increaseSelectedClass, increaseSelectedClass);
    }

 
    public String getInputClass() {
        return (String) getStateHelper().eval(Properties.inputClass);
    }
    
    public void setInputClass(String inputClass) {
        getStateHelper().put(Properties.inputClass, inputClass);
    }

 
    public org.richfaces.component.InputNumberSliderInputPosition getInputPosition() {
        return (InputNumberSliderInputPosition) getStateHelper().eval(Properties.inputPosition, InputNumberSliderInputPosition.DEFAULT);
    }
    
    public void setInputPosition(org.richfaces.component.InputNumberSliderInputPosition inputPosition) {
        getStateHelper().put(Properties.inputPosition, inputPosition);
    }

 
    public int getInputSize() {
        return (Integer) getStateHelper().eval(Properties.inputSize, 3);
    }
    
    public void setInputSize(int inputSize) {
        getStateHelper().put(Properties.inputSize, inputSize);
    }

 
    public String getMaxValue() {
        return (String) getStateHelper().eval(Properties.maxValue, "100");
    }
    
    public void setMaxValue(String maxValue) {
        getStateHelper().put(Properties.maxValue, maxValue);
    }

 
    public int getMaxlength() {
        return (Integer) getStateHelper().eval(Properties.maxlength, Integer.MIN_VALUE);
    }
    
    public void setMaxlength(int maxlength) {
        getStateHelper().put(Properties.maxlength, maxlength);
    }

 
    public String getMinValue() {
        return (String) getStateHelper().eval(Properties.minValue, "0");
    }
    
    public void setMinValue(String minValue) {
        getStateHelper().put(Properties.minValue, minValue);
    }

 
    public String getOnchange() {
        return (String) getStateHelper().eval(Properties.onchange);
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public boolean isShowArrows() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showArrows, false).toString());
    }
    
    public void setShowArrows(boolean showArrows) {
        getStateHelper().put(Properties.showArrows, showArrows);
    }

 
    public boolean isShowBoundaryValues() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showBoundaryValues, true).toString());
    }
    
    public void setShowBoundaryValues(boolean showBoundaryValues) {
        getStateHelper().put(Properties.showBoundaryValues, showBoundaryValues);
    }

 
    public boolean isShowInput() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showInput, true).toString());
    }
    
    public void setShowInput(boolean showInput) {
        getStateHelper().put(Properties.showInput, showInput);
    }

 
    public boolean isShowToolTip() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showToolTip, true).toString());
    }
    
    public void setShowToolTip(boolean showToolTip) {
        getStateHelper().put(Properties.showToolTip, showToolTip);
    }

 
    public String getStep() {
        return (String) getStateHelper().eval(Properties.step, "1");
    }
    
    public void setStep(String step) {
        getStateHelper().put(Properties.step, step);
    }

 
    public String getStyle() {
        return (String) getStateHelper().eval(Properties.style);
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        return (String) getStateHelper().eval(Properties.styleClass);
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public int getTabindex() {
        return (Integer) getStateHelper().eval(Properties.tabindex, Integer.MIN_VALUE);
    }
    
    public void setTabindex(int tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
    }

 
    public String getToolTipClass() {
        return (String) getStateHelper().eval(Properties.toolTipClass);
    }
    
    public void setToolTipClass(String toolTipClass) {
        getStateHelper().put(Properties.toolTipClass, toolTipClass);
    }

 
    public String getTrackClass() {
        return (String) getStateHelper().eval(Properties.trackClass);
    }
    
    public void setTrackClass(String trackClass) {
        getStateHelper().put(Properties.trackClass, trackClass);
    }

}