/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import javax.faces.component.UIInput;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class HtmlInputNumberSpinner extends UIInput
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.InputNumberSpinner";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlInputNumberSpinner() {
        super();
        setRendererType("org.richfaces.InputNumberSpinnerRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "click",
        "blur",
        "upclick",
        "mouseover",
        "mousemove",
        "inputkeyup",
        "inputclick",
        "mouseout",
        "inputmouseover",
        "inputmousemove",
        "inputkeydown",
        "dblclick",
        "inputmouseup",
        "inputmouseout",
        "focus",
        "inputkeypress",
        "downclick",
        "select",
        "inputmousedown",
        "mouseup",
        "change",
        "inputdblclick"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }

    protected static enum Properties {
        accesskey,
        cycled,
        disabled,
        enableManualInput,
        inputClass,
        inputSize,
        maxValue,
        minValue,
        onblur,
        onchange,
        onclick,
        ondblclick,
        ondownclick,
        onfocus,
        oninputclick,
        oninputdblclick,
        oninputkeydown,
        oninputkeypress,
        oninputkeyup,
        oninputmousedown,
        oninputmousemove,
        oninputmouseout,
        oninputmouseover,
        oninputmouseup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onselect,
        onupclick,
        step,
        style,
        styleClass,
        tabindex

    }


 
    public String getAccesskey() {
        return (String) getStateHelper().eval(Properties.accesskey);
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
    }

 
    public boolean isCycled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.cycled, true).toString());
    }
    
    public void setCycled(boolean cycled) {
        getStateHelper().put(Properties.cycled, cycled);
    }

 
    public boolean isDisabled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.disabled, false).toString());
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public boolean isEnableManualInput() {
        return Boolean.valueOf(getStateHelper().eval(Properties.enableManualInput, true).toString());
    }
    
    public void setEnableManualInput(boolean enableManualInput) {
        getStateHelper().put(Properties.enableManualInput, enableManualInput);
    }

 
    public String getInputClass() {
        return (String) getStateHelper().eval(Properties.inputClass);
    }
    
    public void setInputClass(String inputClass) {
        getStateHelper().put(Properties.inputClass, inputClass);
    }

 
    public int getInputSize() {
        return (Integer) getStateHelper().eval(Properties.inputSize, 10);
    }
    
    public void setInputSize(int inputSize) {
        getStateHelper().put(Properties.inputSize, inputSize);
    }

 
    public String getMaxValue() {
        return (String) getStateHelper().eval(Properties.maxValue, "100");
    }
    
    public void setMaxValue(String maxValue) {
        getStateHelper().put(Properties.maxValue, maxValue);
    }

 
    public String getMinValue() {
        return (String) getStateHelper().eval(Properties.minValue, "0");
    }
    
    public void setMinValue(String minValue) {
        getStateHelper().put(Properties.minValue, minValue);
    }

 
    public String getOnblur() {
        return (String) getStateHelper().eval(Properties.onblur);
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnchange() {
        return (String) getStateHelper().eval(Properties.onchange);
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOndownclick() {
        return (String) getStateHelper().eval(Properties.ondownclick);
    }
    
    public void setOndownclick(String ondownclick) {
        getStateHelper().put(Properties.ondownclick, ondownclick);
    }

 
    public String getOnfocus() {
        return (String) getStateHelper().eval(Properties.onfocus);
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOninputclick() {
        return (String) getStateHelper().eval(Properties.oninputclick);
    }
    
    public void setOninputclick(String oninputclick) {
        getStateHelper().put(Properties.oninputclick, oninputclick);
    }

 
    public String getOninputdblclick() {
        return (String) getStateHelper().eval(Properties.oninputdblclick);
    }
    
    public void setOninputdblclick(String oninputdblclick) {
        getStateHelper().put(Properties.oninputdblclick, oninputdblclick);
    }

 
    public String getOninputkeydown() {
        return (String) getStateHelper().eval(Properties.oninputkeydown);
    }
    
    public void setOninputkeydown(String oninputkeydown) {
        getStateHelper().put(Properties.oninputkeydown, oninputkeydown);
    }

 
    public String getOninputkeypress() {
        return (String) getStateHelper().eval(Properties.oninputkeypress);
    }
    
    public void setOninputkeypress(String oninputkeypress) {
        getStateHelper().put(Properties.oninputkeypress, oninputkeypress);
    }

 
    public String getOninputkeyup() {
        return (String) getStateHelper().eval(Properties.oninputkeyup);
    }
    
    public void setOninputkeyup(String oninputkeyup) {
        getStateHelper().put(Properties.oninputkeyup, oninputkeyup);
    }

 
    public String getOninputmousedown() {
        return (String) getStateHelper().eval(Properties.oninputmousedown);
    }
    
    public void setOninputmousedown(String oninputmousedown) {
        getStateHelper().put(Properties.oninputmousedown, oninputmousedown);
    }

 
    public String getOninputmousemove() {
        return (String) getStateHelper().eval(Properties.oninputmousemove);
    }
    
    public void setOninputmousemove(String oninputmousemove) {
        getStateHelper().put(Properties.oninputmousemove, oninputmousemove);
    }

 
    public String getOninputmouseout() {
        return (String) getStateHelper().eval(Properties.oninputmouseout);
    }
    
    public void setOninputmouseout(String oninputmouseout) {
        getStateHelper().put(Properties.oninputmouseout, oninputmouseout);
    }

 
    public String getOninputmouseover() {
        return (String) getStateHelper().eval(Properties.oninputmouseover);
    }
    
    public void setOninputmouseover(String oninputmouseover) {
        getStateHelper().put(Properties.oninputmouseover, oninputmouseover);
    }

 
    public String getOninputmouseup() {
        return (String) getStateHelper().eval(Properties.oninputmouseup);
    }
    
    public void setOninputmouseup(String oninputmouseup) {
        getStateHelper().put(Properties.oninputmouseup, oninputmouseup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnselect() {
        return (String) getStateHelper().eval(Properties.onselect);
    }
    
    public void setOnselect(String onselect) {
        getStateHelper().put(Properties.onselect, onselect);
    }

 
    public String getOnupclick() {
        return (String) getStateHelper().eval(Properties.onupclick);
    }
    
    public void setOnupclick(String onupclick) {
        getStateHelper().put(Properties.onupclick, onupclick);
    }

 
    public String getStep() {
        return (String) getStateHelper().eval(Properties.step, "1");
    }
    
    public void setStep(String step) {
        getStateHelper().put(Properties.step, step);
    }

 
    public String getStyle() {
        return (String) getStateHelper().eval(Properties.style);
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        return (String) getStateHelper().eval(Properties.styleClass);
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public int getTabindex() {
        return (Integer) getStateHelper().eval(Properties.tabindex, Integer.MIN_VALUE);
    }
    
    public void setTabindex(int tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
    }

}