package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.LogRendererBase;


public class AjaxLogRenderer extends LogRendererBase {
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("div", component); 
   {
      String value = "rf-log " + convertToString((convertToBoolean(this.isInline(component.getAttributes().get("mode"))) ? "rf-log-inline" : "rf-log-popup rf-log-popup-cnt")) + " " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

  responseWriter.writeAttribute("id","richfaces.log",null);


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


{
	Object text = "new RichFaces.HtmlLog({\n                    level: \"" + convertToString(component.getAttributes().get("level")) + "\",\n                    hotkey: \"" + convertToString(component.getAttributes().get("hotkey")) + "\",\n                    mode: \"" + convertToString(component.getAttributes().get("mode")) + "\"\n                    /* TODO: pass styleClass in */\n                });";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
}

