package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.AutocompleteRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class AutocompleteRenderer extends AutocompleteRendererBase {
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeBegin(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
Object disabled  = component.getAttributes().get("disabled"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-fld",null);

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("input", component); 
  responseWriter.writeAttribute("class","rf-au-fnt rf-au-inp",null);

   {
      String value = convertToString(clientId) + "Value";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "Value";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","hidden",null);


responseWriter.endElement("input"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("style","position : relative; overflow : hidden; text-align : left; padding-right : 21px;",null);


responseWriter.startElement("input", component); 
  responseWriter.writeAttribute("autocomplete","off",null);

  responseWriter.writeAttribute("class","rf-au-fnt rf-au-inp",null);

      if(null != disabled && ( Boolean.valueOf(disabled.toString()) || "disabled".equals(disabled.toString())) ) {
        responseWriter.writeAttribute("disabled","disabled",null);
      }

   {
      String value = convertToString(clientId) + "Input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("ondblclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("ondblclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onkeydown");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeydown",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onkeypress");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeypress",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onkeyup");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeyup",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmousedown");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousedown",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmousemove");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousemove",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmouseout");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseout",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmouseover");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseover",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmouseup");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseup",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","text",null);

   {
      Object value = component.getAttributes().get("value");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }


responseWriter.endElement("input"); 
	if (convertToBoolean(component.getAttributes().get("showButton"))) {
		if (convertToBoolean(component.getAttributes().get("disabled"))) {
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-au-btn",null);

   {
      String value = convertToString(clientId) + "Button";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-au-btn-arrow",null);


	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
		if ((!convertToBoolean(component.getAttributes().get("disabled")))) {
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-au-btn",null);

   {
      String value = convertToString(clientId) + "Button";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-au-btn-arrow",null);


	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
}
responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-lst-cord",null);

   {
      String value = convertToString(clientId) + "List";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistdblclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("ondblclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistkeydown");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeydown",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistkeypress");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeypress",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistkeyup");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onkeyup",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistmousedown");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousedown",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistmousemove");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousemove",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistmouseout");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseout",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistmouseover");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseover",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onlistmouseup");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseup",value,null);
      }
      
   }


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-shdw",null);


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-shdw-t",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-shdw-l",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-shdw-r",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-shdw-b",null);


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-lst-dcrtn",null);


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-au-lst-scrl",null);



	}
	
@Override
public void encodeChildren(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
encodeItemsContainer(facesContext, component);

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


{
	Object text = "new RichFaces.ui.Autocomplete(\"" + convertToString(clientId) + "\",\n                \"" + convertToString(clientId) + "Input\", " + convertToString(this.getScriptOptions(component)) + "\n                 );";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("div"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

