package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.InplaceState;
import org.richfaces.renderkit.InplaceInputBaseRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class InplaceInputRenderer extends InplaceInputBaseRenderer {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES71 = attributes()
     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick","click")
     

     .generic("ondblclick","ondblclick","ondblclick")
     

     .generic("onkeydown","onkeydown","keydown")
     

     .generic("onkeypress","onkeypress","keypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown","mousedown")
     

     .generic("onmousemove","onmousemove","mousemove")
     

     .generic("onmouseout","onmouseout","mouseout")
     

     .generic("onmouseover","onmouseover","mouseover")
     

     .generic("onmouseup","onmouseup","mouseup")
     

     .generic("style","style")
     

     .generic("title","title")
     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES72 = attributes()
     .generic("tabIndex","tabIndex")
     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
InplaceState inplaceState  = this.getInplaceState(component); 
String inplaceValue  = this.getValue(facesContext,component); 
responseWriter.startElement("span", component); 
   {
      Object value = this.getReadyStyleClass(component,inplaceState);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES71);

responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-ii-lbl",null);

   {
      String value = convertToString(clientId) + ":label";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


{
	Object text = inplaceValue;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("span"); 
responseWriter.startElement("input", component); 
  responseWriter.writeAttribute("class","rf-ii-none",null);

   {
      String value = convertToString(clientId) + ":focus";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","position: absolute; top: 0px; left: 0px; outline-style: none;",null);

  responseWriter.writeAttribute("type","image",null);


responseWriter.endElement("input"); 
responseWriter.startElement("span", component); 
   {
      Object value = this.getEditStyleClass(component,inplaceState);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":edit";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("input", component); 
  responseWriter.writeAttribute("autocomplete","off",null);

  responseWriter.writeAttribute("class","rf-ii-fld",null);

   {
      String value = convertToString(clientId) + ":input";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

   {
      String value = "width: " + convertToString(component.getAttributes().get("inputWidth")) + ";";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","text",null);

   {
      Object value = this.getInputValue(facesContext,component);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES72);

renderInputHandlers(facesContext, component);;
responseWriter.endElement("input"); 
	if (convertToBoolean(component.getAttributes().get("showControls"))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-prepos",null);


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-pos",null);


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-shdw",null);

   {
      String value = convertToString(clientId) + ":btnshadow";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-shdw-t",null);


	responseWriter.endElement("span"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-shdw-l",null);


	responseWriter.endElement("span"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-shdw-r",null);


	responseWriter.endElement("span"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn-shdw-b",null);


	responseWriter.endElement("span"); 
	responseWriter.startElement("span", component); 
	   {
      String value = convertToString(clientId) + ":btn";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","position : relative",null);


	responseWriter.startElement("input", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn",null);

   {
      String value = convertToString(clientId) + ":okbtn";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("onmousedown","this.className='rf-ii-btn-prsd'",null);

  responseWriter.writeAttribute("onmouseout","this.className='rf-ii-btn'",null);

  responseWriter.writeAttribute("onmouseup","this.className='rf-ii-btn'",null);

   {
      Object value = this.getResourcePath(facesContext,"org.richfaces/ico_ok.gif");
      if(null != value && value.toString().length()>0) {
        responseWriter.writeURIAttribute("src",value,null);
      }
   }

  responseWriter.writeAttribute("type","image",null);


	responseWriter.endElement("input"); 
	responseWriter.startElement("input", component); 
	  responseWriter.writeAttribute("class","rf-ii-btn",null);

   {
      String value = convertToString(clientId) + ":cancelbtn";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("onmousedown","this.className='rf-ii-btn-prsd'",null);

  responseWriter.writeAttribute("onmouseout","this.className='rf-ii-btn'",null);

  responseWriter.writeAttribute("onmouseup","this.className='rf-ii-btn'",null);

   {
      Object value = this.getResourcePath(facesContext,"org.richfaces/ico_cancel.gif");
      if(null != value && value.toString().length()>0) {
        responseWriter.writeURIAttribute("src",value,null);
      }
   }

  responseWriter.writeAttribute("type","image",null);


	responseWriter.endElement("input"); 
	responseWriter.startElement("br", component); 
	
	responseWriter.endElement("br"); 
	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
}
responseWriter.endElement("span"); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


buildScript(responseWriter, facesContext, component);;
responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
}

