package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.InputNumberSliderRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import static org.richfaces.renderkit.RenderKitUtils.*;


@ResourceDependencies({@ResourceDependency(name="inputNumberSlider.ecss",library="org.richfaces",target=""),@ResourceDependency(name="base-component.reslib",library="org.richfaces",target=""),@ResourceDependency(name="jquery.position.js",library="",target=""),@ResourceDependency(name="inputNumberSlider.js",library="org.richfaces",target="")})
public class InputNumberSliderRenderer extends InputNumberSliderRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES73 = attributes()
     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick","click")
     

     .generic("ondblclick","ondblclick","dblclick")
     

     .generic("onkeydown","onkeydown","keydown")
     

     .generic("onkeypress","onkeypress","keypress")
     

     .generic("onkeyup","onkeyup","keyup")
     

     .generic("onmousedown","onmousedown","mousedown")
     

     .generic("onmousemove","onmousemove","mousemove")
     

     .generic("onmouseout","onmouseout","mouseout")
     

     .generic("onmouseover","onmouseover","mouseover")
     

     .generic("onmouseup","onmouseup","mouseup")
     

     .generic("style","style")
     

     .generic("title","title")
     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES74 = attributes()
     .generic("accesskey","accesskey")
     

     .bool("disabled","disabled")
     

     .generic("maxlength","maxlength")
     

     .generic("size","inputSize")
     

     .generic("tabindex","tabindex")
     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES75 = attributes()
     .generic("accesskey","accesskey")
     

     .bool("disabled","disabled")
     

     .generic("maxlength","maxlength")
     

     .generic("size","inputSize")
     

     .generic("tabindex","tabindex")
     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = "rf-insl " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES73);

	if ((convertToBoolean(this.isInputPosition(component,"left")) || convertToBoolean(this.isInputPosition(component,"top")))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-insl-inp-cntr",null);


	responseWriter.startElement("input", component); 
	   {
      String value = "rf-insl-inp " + convertToString(component.getAttributes().get("inputClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

      if((!convertToBoolean(component.getAttributes().get("enableManualInput")))) {
        responseWriter.writeAttribute("readonly","readonly",null);
      }

   {
      String value = (convertToBoolean(component.getAttributes().get("showInput")) ? null : "display: none;");
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","text",null);

   {
      Object value = this.getInputValue(facesContext,component);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES74);

	responseWriter.endElement("input"); 
	responseWriter.endElement("span"); 
		if ((convertToBoolean(this.isInputPosition(component,"top")) && convertToBoolean(component.getAttributes().get("showInput")))) {
	responseWriter.startElement("br", component); 
	
	responseWriter.endElement("br"); 
}
}
	if (convertToBoolean(component.getAttributes().get("showArrows"))) {
	responseWriter.startElement("span", component); 
	   {
      String value = "rf-insl-dec" + convertToString((convertToBoolean(component.getAttributes().get("disabled")) ? "-dis" : "")) + " " + convertToString(component.getAttributes().get("decreaseClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	responseWriter.endElement("span"); 
}
responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-insl-trc-cntr",null);


	if (convertToBoolean(component.getAttributes().get("showBoundaryValues"))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-insl-mn",null);


	{
	Object text = component.getAttributes().get("minValue");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-insl-mx",null);


	{
	Object text = component.getAttributes().get("maxValue");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
}
responseWriter.startElement("span", component); 
   {
      String value = "rf-insl-trc " + convertToString(component.getAttributes().get("trackClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


responseWriter.startElement("span", component); 
   {
      String value = "rf-insl-hnd" + convertToString((convertToBoolean(component.getAttributes().get("disabled")) ? "-dis" : "")) + " " + convertToString(component.getAttributes().get("handleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


responseWriter.endElement("span"); 
responseWriter.endElement("span"); 
responseWriter.endElement("span"); 
	if (convertToBoolean(component.getAttributes().get("showArrows"))) {
	responseWriter.startElement("span", component); 
	   {
      String value = "rf-insl-inc" + convertToString((convertToBoolean(component.getAttributes().get("disabled")) ? "-dis" : "")) + " " + convertToString(component.getAttributes().get("increaseClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	responseWriter.endElement("span"); 
}
	if ((convertToBoolean(this.isInputPosition(component,"right")) || convertToBoolean(this.isInputPosition(component,"bottom")))) {
		if ((convertToBoolean(this.isInputPosition(component,"bottom")) && convertToBoolean(component.getAttributes().get("showInput")))) {
	responseWriter.startElement("br", component); 
	
	responseWriter.endElement("br"); 
}
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-insl-inp-cntr",null);


	responseWriter.startElement("input", component); 
	   {
      String value = "rf-insl-inp " + convertToString(component.getAttributes().get("inputClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

      if((!convertToBoolean(component.getAttributes().get("enableManualInput")))) {
        responseWriter.writeAttribute("readonly","readonly",null);
      }

   {
      String value = (convertToBoolean(component.getAttributes().get("showInput")) ? null : "display: none;");
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }

  responseWriter.writeAttribute("type","text",null);

   {
      Object value = this.getInputValue(facesContext,component);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("value",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES75);

	responseWriter.endElement("input"); 
	responseWriter.endElement("span"); 
}
	if (convertToBoolean(component.getAttributes().get("showToolTip"))) {
	responseWriter.startElement("span", component); 
	   {
      String value = "rf-insl-tt " + convertToString(component.getAttributes().get("toolTipClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	{
	Object text = this.getInputValue(facesContext,component);
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
}
String onchange  = this.convertToString(RenderKitUtils.getAttributeAndBehaviorsValue(facesContext,component,RenderKitUtils.attributes().generic("onchange","onchange","change").first())); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


{
	Object text = "new RichFaces.ui.InputNumberSlider('" + convertToString(clientId) + "', {\n\t\t\t\tdelay: " + convertToString(component.getAttributes().get("delay")) + ",\n\t\t\t\tdisabled: " + convertToString(component.getAttributes().get("disabled")) + ",\n\t\t\t\tmaxValue: " + convertToString(component.getAttributes().get("maxValue")) + ",\n\t\t\t\tminValue: " + convertToString(component.getAttributes().get("minValue")) + ",\n\t\t\t\tonchange: " + convertToString(((onchange.length() > 0) ? (("function (event) {" + onchange) + "}") : "null")) + ",\n\t\t\t\tstep: " + convertToString(component.getAttributes().get("step")) + ",\n\t\t\t\ttabIndex: " + convertToString((convertToBoolean(RenderKitUtils.shouldRenderAttribute(component.getAttributes().get("tabindex"))) ? component.getAttributes().get("tabindex") : "null")) + "\n\t\t\t}, {\n\t\t\t\tdecreaseSelectedClass: '" + convertToString(component.getAttributes().get("decreaseSelectedClass")) + "',\n\t\t\t\thandleSelectedClass: '" + convertToString(component.getAttributes().get("handleSelectedClass")) + "',\n\t\t\t\tincreaseSelectedClass: '" + convertToString(component.getAttributes().get("increaseSelectedClass")) + "'\n\t\t\t});";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
}

