package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.JQueryRendererBase;


public class JQueryRenderer extends JQueryRendererBase {
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean isEmpty(Object object) 
 {
		return object == null;
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","display: none;",null);


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


Object functionName  = component.getAttributes().get("name"); 
Object options  = this.getOptionsAsJavascriptString(facesContext,component); 
	if ((!isEmpty(functionName))) {
	{
	Object text = convertToString(functionName) + " = RichFaces.jQuery.createFunction(" + convertToString(options) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	} else  { 
	{
	Object text = "RichFaces.jQuery.query(" + convertToString(options) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

