package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.html.ProgressBarBaseRenderer;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class ProgressBarRenderer extends ProgressBarBaseRenderer {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES36 = attributes()
     .generic("align","align")
     

     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick","click")
     

     .generic("ondblclick","ondblclick","dblclick")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown","mousedown")
     

     .generic("onmousemove","onmousemove","mousemove")
     

     .generic("onmouseover","onmouseover","mouseover")
     

     .generic("onmouseup","onmouseup","mouseup")
     

     .generic("title","title")
     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES37 = attributes()
     .generic("align","align")
     

     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick","click")
     

     .generic("ondblclick","ondblclick","dblclick")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown","mousedown")
     

     .generic("onmousemove","onmousemove","mousemove")
     

     .generic("onmouseover","onmouseover","mouseover")
     

     .generic("onmouseup","onmouseup","mouseup")
     

     .generic("title","title")
     
;
	
	
private static boolean isEqual(Object o1, Object o2) 
 {
		if (o1 != null) {
	return o1.equals(o2);
} else {
	//o1 == null
	return o2 == null;
}
	}
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
	if (convertToBoolean(this.isAjaxMode(component))) {
	String state  = this.getCurrentOrForcedState(facesContext,component); 
		if (isEqual(state,"initialState")) {
	responseWriter.startElement("div", component); 
	   {
      Object value = component.getAttributes().get("initialClass");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	renderInitialFacet(facesContext, component);
	responseWriter.endElement("div"); 
}
		if (isEqual(state,"completeState")) {
	responseWriter.startElement("div", component); 
	   {
      Object value = component.getAttributes().get("finishClass");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	renderCompleteFacet(facesContext, component);
	responseWriter.endElement("div"); 
}
		if (isEqual(state,"progressState")) {
	String shellStyle  = this.getShellStyle(facesContext,component); 
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-cnt " + convertToString(shellStyle) + " " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES36);

		if ((!convertToBoolean(this.isSimpleMarkup(component)))) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-rmnd " + convertToString(component.getAttributes().get("remainClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":remain";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-pb-upl-dig",null);

   {
      String value = convertToString(clientId) + ":upload";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + "; width:" + convertToString(this.getWidth(component)) + "%;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-cmpltd " + convertToString(component.getAttributes().get("completeClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":complete";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
		if (convertToBoolean(this.isSimpleMarkup(component))) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-upl " + convertToString(component.getAttributes().get("completeClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":upload";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + "; width:" + convertToString(this.getWidth(component)) + "%;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
}
	responseWriter.startElement("script", component); 
	  responseWriter.writeAttribute("type","text/javascript",null);


	{
	Object text = convertToString(this.getInitialScript(facesContext,component,"progressState")) + "\n\t\t\t\t\t\t" + convertToString(this.getPollScript(facesContext,component));
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("script"); 
	responseWriter.endElement("div"); 
}
	} else  { 
	responseWriter.startElement("div", component); 
	   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	   {
      Object value = component.getAttributes().get("initialClass");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":initialState";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + " display:none;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	renderInitialFacet(facesContext, component);
	responseWriter.endElement("div"); 
	String shellStyle  = this.getShellStyle(facesContext,component); 
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-cnt " + convertToString(shellStyle) + " " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":progressState";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + " display:none;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES37);

		if ((!convertToBoolean(this.isSimpleMarkup(component)))) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-rmnd " + convertToString(component.getAttributes().get("remainClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":remain";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-pb-upl-dig",null);

   {
      String value = convertToString(clientId) + ":upload";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + "; width=" + convertToString(this.getWidth(component)) + "%;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-cmpltd  " + convertToString(component.getAttributes().get("completeClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":complete";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
		if (convertToBoolean(this.isSimpleMarkup(component))) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-pb-upl " + convertToString(component.getAttributes().get("completeClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":upload";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + "; width=" + convertToString(this.getWidth(component)) + "%;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
}
	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	   {
      Object value = component.getAttributes().get("finishClass");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + ":completeState";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = convertToString(component.getAttributes().get("style")) + " display:none;";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


	renderCompleteFacet(facesContext, component);
	responseWriter.endElement("div"); 
	String state  = this.getCurrentState(facesContext,component); 
	responseWriter.startElement("script", component); 
	  responseWriter.writeAttribute("type","text/javascript",null);


	{
	Object text = convertToString(this.getInitialScript(facesContext,component,state)) + "\n\t\t\t\t" + convertToString(this.getRenderStateScript(facesContext,component,state));
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("script"); 
	responseWriter.endElement("div"); 
}

	}
}

