/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import org.richfaces.exception.FileUploadException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.request.MultipartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadPartialViewContextFactory
extends PartialViewContextFactory {
    public static final String UID_KEY = "rf_fu_uid";
    public static final String UID_ALT_KEY = "rf_fu_uid_alt";
    private static final Logger LOGGER = RichfacesLogger.CONTEXT.getLogger();
    private static final Pattern AMPERSAND = Pattern.compile("&+");
    private PartialViewContextFactory parentFactory;
    private boolean createTempFiles = true;
    private String tempFilesDirectory;
    private long maxRequestSize = 0L;

    public FileUploadPartialViewContextFactory(PartialViewContextFactory parentFactory) {
        this.parentFactory = parentFactory;
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        String param = context.getInitParameter("org.richfaces.fileUpload.createTempFiles");
        if (param != null) {
            this.createTempFiles = Boolean.parseBoolean(param);
        }
        this.tempFilesDirectory = context.getInitParameter("org.richfaces.fileUpload.tempFilesDirectory");
        param = context.getInitParameter("org.richfaces.fileUpload.maxRequestSize");
        if (param != null) {
            this.maxRequestSize = Long.parseLong(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialViewContext getPartialViewContext(FacesContext facesContext) {
        Object partialViewContext = this.parentFactory.getPartialViewContext(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        Map<String, String> queryParamMap = this.parseQueryString(request.getQueryString());
        String uid = queryParamMap.get(UID_KEY);
        if (uid != null) {
            long contentLength = Long.parseLong((String)externalContext.getRequestHeaderMap().get("Content-Length"));
            if (this.maxRequestSize != 0L && contentLength > this.maxRequestSize) {
                this.printResponse(facesContext, uid, ResponseState.sizeExceeded);
            } else {
                final MultipartRequest multipartRequest = new MultipartRequest(request, this.createTempFiles, this.tempFilesDirectory, uid);
                try {
                    final PartialViewContext viewContext = partialViewContext;
                    partialViewContext = new PartialViewContextWrapper(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void processPartial(PhaseId phaseId) {
                            try {
                                super.processPartial(phaseId);
                            }
                            finally {
                                if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
                                    multipartRequest.cancel();
                                }
                            }
                        }

                        public void setPartialRequest(boolean isPartialRequest) {
                            viewContext.setPartialRequest(isPartialRequest);
                        }

                        public PartialViewContext getWrapped() {
                            return viewContext;
                        }
                    };
                    multipartRequest.parseRequest();
                    if (!multipartRequest.isDone()) {
                        this.printResponse(facesContext, uid, ResponseState.stopped);
                    } else {
                        externalContext.setRequest((Object)multipartRequest);
                    }
                }
                catch (FileUploadException e) {
                    this.printResponse(facesContext, uid, ResponseState.serverError);
                }
                finally {
                    multipartRequest.clearRequestData();
                }
            }
        }
        return partialViewContext;
    }

    private Map<String, String> parseQueryString(String queryString) {
        if (queryString != null) {
            String[] nvPairs;
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (String nvPair : nvPairs = AMPERSAND.split(queryString)) {
                int eqIdx;
                if (nvPair.length() == 0 || (eqIdx = nvPair.indexOf(61)) < 0) continue;
                try {
                    String name = URLDecoder.decode(nvPair.substring(0, eqIdx), "UTF-8");
                    if (parameters.containsKey(name)) continue;
                    String value = URLDecoder.decode(nvPair.substring(eqIdx + 1), "UTF-8");
                    parameters.put(name, value);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return parameters;
        }
        return Collections.emptyMap();
    }

    private void printResponse(FacesContext facesContext, String uid, ResponseState state) {
        facesContext.responseComplete();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.setResponseStatus(200);
        externalContext.setResponseContentType("text/html");
        try {
            Writer writer = externalContext.getResponseOutputWriter();
            writer.write("<html id=\"rf_fu_uid" + uid + ":" + (Object)((Object)state) + "\"/>");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResponseState {
        sizeExceeded,
        stopped,
        serverError;

    }
}

