/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.component.util.Strings;
import org.richfaces.javascript.ClientScriptService;
import org.richfaces.javascript.ClientSideScript;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.javascript.LibraryFunctionImplementation;
import org.richfaces.javascript.ScriptNotFoundException;
import org.richfaces.resource.ResourceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientScriptServiceImpl
implements ClientScriptService {
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String ORG_RICHFACES_CSV = "org.richfaces.csv";
    private final Map<Class<?>, LibraryFunction> defaultMapping;

    public ClientScriptServiceImpl(Map<Class<?>, LibraryFunction> defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public LibraryFunction getScript(FacesContext facesContext, Class<?> javaClass) throws ScriptNotFoundException {
        LibraryFunction function;
        if (null == facesContext || null == javaClass) {
            throw new NullPointerException();
        }
        try {
            function = this.getScriptResource(facesContext, javaClass);
        }
        catch (ScriptNotFoundException e) {
            function = this.defaultMapping.containsKey(javaClass) ? this.defaultMapping.get(javaClass) : this.getScriptFromAnnotation(javaClass);
        }
        return function;
    }

    private LibraryFunction getScriptFromAnnotation(Class<?> javaClass) throws ScriptNotFoundException {
        if (javaClass.isAnnotationPresent(ClientSideScript.class)) {
            ClientSideScript clientSideScript = javaClass.getAnnotation(ClientSideScript.class);
            ArrayList resources = Lists.newArrayList();
            for (ResourceDependency dependency : clientSideScript.resources()) {
                resources.add(ResourceKey.create((String)dependency.name(), (String)dependency.library()));
            }
            return new LibraryFunctionImplementation(clientSideScript.function(), resources);
        }
        throw new ScriptNotFoundException();
    }

    private LibraryFunction getScriptResource(FacesContext facesContext, Class<?> javaClass) throws ScriptNotFoundException {
        String resourceName;
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource facesResource = resourceHandler.createResource(resourceName = javaClass.getSimpleName() + ".js", ORG_RICHFACES_CSV, TEXT_JAVASCRIPT);
        if (null != facesResource) {
            String functionName = Strings.firstToLowerCase(javaClass.getSimpleName());
            return new LibraryFunctionImplementation(functionName, resourceName, ORG_RICHFACES_CSV);
        }
        throw new ScriptNotFoundException();
    }
}

