/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.application.ServiceTracker;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.MessageForRender;
import org.richfaces.renderkit.MessageTransformer;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRendererBase
extends Renderer {
    private static final ImmutableMap<FacesMessage.Severity, SeverityAttributes> SEVERITY_MAP = ImmutableMap.of((Object)FacesMessage.SEVERITY_INFO, (Object)MessageRendererBase.attrs("info", "inf", null), (Object)FacesMessage.SEVERITY_WARN, (Object)MessageRendererBase.attrs("warn", "wrn", null), (Object)FacesMessage.SEVERITY_ERROR, (Object)MessageRendererBase.attrs("error", "err", null), (Object)FacesMessage.SEVERITY_FATAL, (Object)MessageRendererBase.attrs("fatal", "ftl", null));

    protected Iterator<MessageForRender> getMessages(FacesContext context, String forClientId, UIComponent component) {
        Object msgIter;
        if (forClientId != null) {
            if (forClientId.length() != 0) {
                UIComponent result = RendererUtils.getInstance().findComponentFor(component, forClientId);
                if (result == null) {
                    msgIter = Iterators.emptyIterator();
                } else {
                    String clientId = result.getClientId(context);
                    msgIter = this.getMessagesForId(context, clientId);
                }
            } else {
                msgIter = this.getMessagesForId(context, null);
            }
        } else {
            msgIter = Iterators.emptyIterator();
            Iterator clientIdsWithMessages = context.getClientIdsWithMessages();
            while (clientIdsWithMessages.hasNext()) {
                String clientId = (String)clientIdsWithMessages.next();
                msgIter = Iterators.concat((Iterator)msgIter, this.getMessagesForId(context, clientId));
            }
        }
        return msgIter;
    }

    private Iterator<MessageForRender> getMessagesForId(FacesContext context, String clientId) {
        Iterator msgIter = Iterators.transform((Iterator)context.getMessages(clientId), (Function)new MessageTransformer(null == clientId ? "" : clientId));
        return msgIter;
    }

    protected Iterable<MessageForRender> getVisibleMessages(FacesContext context, UIComponent component) {
        String forId = this.getFor(component);
        Iterator<MessageForRender> messages = this.getMessages(context, forId, component);
        UnmodifiableIterator filteredMessages = Iterators.filter(messages, this.getMessagesLevelFilter(context, component));
        return Lists.newArrayList((Iterator)filteredMessages);
    }

    private Predicate<MessageForRender> getMessagesLevelFilter(FacesContext context, UIComponent component) {
        final FacesMessage.Severity level = this.getLevel(component);
        final boolean displayAll = component instanceof UIMessages;
        final boolean redisplay = Boolean.TRUE.equals(component.getAttributes().get("redisplay"));
        Predicate<MessageForRender> predicate = new Predicate<MessageForRender>(){
            private int count = 0;

            public boolean apply(MessageForRender input) {
                if ((redisplay || !input.isRendered()) && input.getSeverity().compareTo((Object)level) >= 0) {
                    return displayAll || 0 == this.count++;
                }
                return false;
            }
        };
        return predicate;
    }

    private FacesMessage.Severity getLevel(UIComponent component) {
        Object levelName = component.getAttributes().get("level");
        FacesMessage.Severity level = FacesMessage.VALUES_MAP.containsKey(levelName) ? FacesMessage.VALUES_MAP.get(levelName) : FacesMessage.SEVERITY_INFO;
        return level;
    }

    private String getFor(UIComponent component) {
        if (component instanceof UIMessages) {
            UIMessages messages = (UIMessages)component;
            if (messages.isGlobalOnly()) {
                return "";
            }
            return messages.getFor();
        }
        if (component instanceof UIMessage) {
            UIMessage message = (UIMessage)component;
            return message.getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected void encodeMessage(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        String summary = message.getSummary();
        String detail = message.getDetail();
        boolean showSummary = true;
        boolean showDetail = false;
        if (component instanceof UIMessage) {
            UIMessage uiMessage = (UIMessage)component;
            showSummary = uiMessage.isShowSummary();
            showDetail = uiMessage.isShowDetail();
        } else if (component instanceof UIMessages) {
            UIMessages uiMessages = (UIMessages)component;
            showSummary = uiMessages.isShowSummary();
            showDetail = uiMessages.isShowDetail();
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.writeAttribute("id", (Object)(component.getClientId() + ':' + message.getSourceId()), null);
        boolean wroteTooltip = Boolean.TRUE.equals(component.getAttributes().get("tooltip"));
        if (wroteTooltip && !Strings.isNullOrEmpty((String)summary)) {
            responseWriter.writeAttribute("title", (Object)summary, null);
        }
        if (!wroteTooltip && showSummary) {
            this.writeMessageLabel(responseWriter, summary, "rf-msg-sum");
        }
        if (showDetail) {
            this.writeMessageLabel(responseWriter, detail, "rf-msg-det");
        }
        message.rendered();
    }

    private void writeMessageLabel(ResponseWriter responseWriter, String label, String styleClass) throws IOException {
        if (!Strings.isNullOrEmpty((String)label)) {
            responseWriter.startElement("span", null);
            responseWriter.writeAttribute("class", (Object)styleClass, null);
            responseWriter.writeText((Object)label, null);
            responseWriter.endElement("span");
        }
    }

    protected void encodeScript(FacesContext facesContext, UIComponent component) throws IOException {
        FacesMessage.Severity level;
        UIComponent target;
        JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
        JSObject messageObject = new JSObject("RichFaces.ui.Message", new Object[]{component.getClientId(facesContext)});
        Map attributes = component.getAttributes();
        ImmutableMap.Builder parametersBuilder = ImmutableMap.builder();
        String forId = (String)attributes.get("for");
        if (!Strings.isNullOrEmpty((String)forId) && null != (target = RendererUtils.getInstance().findComponentFor(component, forId))) {
            parametersBuilder.put((Object)"forComponentId", (Object)target.getClientId(facesContext));
        }
        if (FacesMessage.SEVERITY_INFO != (level = this.getLevel(component))) {
            parametersBuilder.put((Object)"level", (Object)level.getOrdinal());
        }
        if (!Boolean.TRUE.equals(attributes.get("showSummary"))) {
            parametersBuilder.put((Object)"showSummary", (Object)false);
        }
        if (Boolean.TRUE.equals(attributes.get("showDetail"))) {
            parametersBuilder.put((Object)"showDetail", (Object)true);
        }
        if (Boolean.TRUE.equals(attributes.get("tooltip"))) {
            parametersBuilder.put((Object)"tooltip", (Object)true);
        }
        messageObject.addParameter((Object)parametersBuilder.build());
        javaScriptService.addPageReadyScript(facesContext, (Object)messageObject);
    }

    protected String getMsgClass(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        SeverityAttributes severityAttributes = (SeverityAttributes)SEVERITY_MAP.get((Object)message.getSeverity());
        String styleClass = this.buildSeverityAttribute(component, severityAttributes.skinClass, severityAttributes.classAttribute, ' ');
        return styleClass;
    }

    protected String getMsgStyle(FacesContext facesContext, UIComponent component, Object msg) throws IOException {
        MessageForRender message = (MessageForRender)msg;
        SeverityAttributes severityAttributes = (SeverityAttributes)SEVERITY_MAP.get((Object)message.getSeverity());
        String style = this.buildSeverityAttribute(component, severityAttributes.skinStyle, severityAttributes.styleAttribute, ';');
        return style;
    }

    private String buildSeverityAttribute(UIComponent component, String skinValue, String attrName, char delimiter) {
        Object componentStyle;
        StringBuilder style = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)skinValue)) {
            style.append(skinValue);
        }
        if (null != (componentStyle = component.getAttributes().get(attrName)) && !Strings.isNullOrEmpty((String)componentStyle.toString())) {
            if (!Strings.isNullOrEmpty((String)skinValue)) {
                style.append(delimiter);
            }
            style.append(componentStyle);
        }
        return style.toString();
    }

    static SeverityAttributes attrs(String attPrefix, String skinSuffix, String skinStyle) {
        SeverityAttributes attrs = new SeverityAttributes(attPrefix + "Style", attPrefix + "Class", skinStyle, "rf-msg-" + skinSuffix, null, null);
        return attrs;
    }

    private static final class SeverityAttributes {
        private final String styleAttribute;
        private final String classAttribute;
        private final String skinStyle;
        private final String skinClass;
        private final String labelStyleAttribute;
        private final String labelClassAttribute;

        private SeverityAttributes(String styleAttribute2, String classAttribute2, String markerStyleAttribute2, String markerClassAttribute2, String labelStyleAttribute2, String labelClassAttribute2) {
            this.styleAttribute = styleAttribute2;
            this.classAttribute = classAttribute2;
            this.skinStyle = markerStyleAttribute2;
            this.skinClass = markerClassAttribute2;
            this.labelStyleAttribute = labelStyleAttribute2;
            this.labelClassAttribute = labelClassAttribute2;
        }
    }
}

