/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractCollapsiblePanel;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.renderkit.html.TableIconsRendererHelper;
import org.richfaces.renderkit.html.TogglePanelRenderer;
import org.richfaces.renderkit.util.PanelIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="togglePanel.js"), @ResourceDependency(library="org.richfaces", name="togglePanelItem.js"), @ResourceDependency(library="org.richfaces", name="collapsiblePanel.js"), @ResourceDependency(library="org.richfaces", name="collapsiblePanelItem.js"), @ResourceDependency(library="org.richfaces", name="icons.ecss"), @ResourceDependency(library="org.richfaces", name="collapsiblePanel.ecss")})
public class CollapsiblePanelRenderer
extends TogglePanelRenderer {
    public static final String SWITCH = "switch";
    public static final String BEFORE_SWITCH = "beforeswitch";
    private final TableIconsRendererHelper<AbstractCollapsiblePanel> headerRenderer = new TableIconsRendererHelper<AbstractCollapsiblePanel>("header", "rf-cp"){

        @Override
        protected void encodeHeaderLeftIcon(ResponseWriter writer, FacesContext context, AbstractCollapsiblePanel panel) throws IOException {
            String leftExpandedIcon;
            String leftCollapsedIcon = panel.getLeftCollapsedIcon();
            if (leftCollapsedIcon == null || leftCollapsedIcon.trim().length() == 0) {
                leftCollapsedIcon = PanelIcons.chevronUp.toString();
            }
            if ((leftExpandedIcon = panel.getLeftExpandedIcon()) == null || leftExpandedIcon.trim().length() == 0) {
                leftExpandedIcon = PanelIcons.chevronDown.toString();
            }
            this.encodeTdIcon(writer, context, this.cssClassPrefix + "-ico", leftCollapsedIcon, leftExpandedIcon, PanelIcons.State.header);
        }

        @Override
        protected void encodeHeaderRightIcon(ResponseWriter writer, FacesContext context, AbstractCollapsiblePanel panel) throws IOException {
            this.encodeTdIcon(writer, context, this.cssClassPrefix + "-exp-ico", panel.getRightCollapsedIcon(), panel.getRightExpandedIcon(), PanelIcons.State.header);
        }

        @Override
        protected void encodeHeaderTextValue(ResponseWriter writer, FacesContext context, AbstractCollapsiblePanel component) throws IOException {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)(this.cssClassPrefix + "-lbl-exp"), null);
            1.writeFacetOrAttr(writer, context, (UIComponent)component, this.text, this.text + "Expanded");
            writer.endElement("div");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)(this.cssClassPrefix + "-lbl-colps"), null);
            1.writeFacetOrAttr(writer, context, (UIComponent)component, this.text, this.text + "Collapsed");
            writer.endElement("div");
        }
    };

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String compClientId;
        String clientId;
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(CollapsiblePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
        }
        if ((clientId = (String)requestMap.get(compClientId = component.getClientId(context))) != null && clientId.equals(compClientId)) {
            context.getPartialViewContext().getRenderIds().add(clientId);
            CollapsiblePanelRenderer.addOnCompleteParam(context, newValue, panel.getClientId(context));
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        this.encodeHeader(writer, context, (AbstractCollapsiblePanel)component);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return this.concatClasses("rf-cp", super.getStyleClass(component));
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.CollapsiblePanel", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("ajax", (Object)CollapsiblePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        options.put("switchMode", panel.getSwitchType());
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, SWITCH);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, BEFORE_SWITCH);
        return options;
    }

    private void encodeHeader(ResponseWriter writer, FacesContext context, AbstractCollapsiblePanel component) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":header"), null);
        writer.writeAttribute("class", (Object)this.concatClasses("rf-cp-hdr", "rf-cp-hdr-" + (component.isExpanded() ? "exp" : "colps"), CollapsiblePanelRenderer.attributeAsString((UIComponent)component, "headerClass")), null);
        this.headerRenderer.encodeHeader(writer, context, component);
        writer.endElement("div");
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractCollapsiblePanel panel = (AbstractCollapsiblePanel)component;
        this.encodeContentChild(writer, context, component, panel);
        this.encodeEmptyChild(writer, context, component, panel);
    }

    private void encodeContentChild(ResponseWriter writer, FacesContext context, UIComponent component, AbstractCollapsiblePanel panel) throws IOException {
        if (panel.isExpanded()) {
            this.encodeContent(writer, context, component, true);
        } else {
            switch (panel.getSwitchType()) {
                case client: {
                    this.encodeContent(writer, context, component, false);
                    break;
                }
                case ajax: {
                    context.getResponseWriter().write(this.getPlaceHolder(panel.getClientId(context) + ":content"));
                    break;
                }
                case server: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch type : " + panel.getSwitchType());
                }
            }
        }
    }

    private void encodeEmptyChild(ResponseWriter writer, FacesContext context, UIComponent component, AbstractCollapsiblePanel panel) throws IOException {
        if (!panel.isExpanded()) {
            this.encodeEmptyDiv(writer, context, component, true);
        } else {
            switch (panel.getSwitchType()) {
                case client: {
                    this.encodeEmptyDiv(writer, context, component, false);
                    break;
                }
                case ajax: {
                    writer.write(this.getPlaceHolder(panel.getClientId(context) + ":empty"));
                    break;
                }
                case server: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch type : " + panel.getSwitchType());
                }
            }
        }
    }

    private String getPlaceHolder(String id) {
        return "<div id=\"" + id + "\" style=\"display:none\" ></div>";
    }

    private void encodeContent(ResponseWriter writer, FacesContext context, UIComponent component, boolean visible) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":content"), null);
        writer.writeAttribute("class", (Object)this.concatClasses("rf-cp-b", CollapsiblePanelRenderer.attributeAsString(component, "bodyClass")), null);
        writer.writeAttribute("style", (Object)CollapsiblePanelRenderer.styleElement("display", visible ? "block" : "none"), null);
        this.renderChildren(context, component);
        writer.endElement("div");
    }

    private void encodeEmptyDiv(ResponseWriter writer, FacesContext context, UIComponent component, boolean visible) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":empty"), null);
        writer.writeAttribute("class", (Object)"rf-cp-empty", null);
        writer.writeAttribute("style", (Object)CollapsiblePanelRenderer.styleElement("display", visible ? "block" : "none"), null);
        writer.endElement("div");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractCollapsiblePanel.class;
    }
}

