/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractPanelMenuItem;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TogglePanelRenderer;
import org.richfaces.renderkit.util.PanelIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelMenuItemRenderer
extends DivPanelRenderer {
    public static final String UNSELECT = "unselect";
    public static final String SELECT = "select";
    public static final String BEFORE_SELECT = "beforeselect";
    private static final String CSS_CLASS_PREFIX = "rf-pm-itm";
    private static final String TOP_CSS_CLASS_PREFIX = "rf-pm-top-itm";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String compClientId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.get(compClientId = component.getClientId(context)) != null) {
            AbstractPanelMenuItem panelItem = (AbstractPanelMenuItem)component;
            new ActionEvent((UIComponent)panelItem).queue();
            if (context.getPartialViewContext().isPartialRequest()) {
                context.getPartialViewContext().getRenderIds().add(panelItem.getClientId(context));
                PanelMenuItemRenderer.addOnCompleteParam(context, panelItem.getClientId(context));
            }
        }
    }

    protected static void addOnCompleteParam(FacesContext context, String itemId) {
        ExtendedPartialViewContext.getInstance((FacesContext)context).appendOncomplete((Object)("RichFaces.$('" + itemId + "').onCompleteHandler();"));
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        this.encodeHeaderGroupBegin(writer, context, menuItem, this.getCssClass(menuItem, ""));
    }

    private void encodeHeaderGroupBegin(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)(classPrefix + "-gr"), null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        this.encodeHeaderGroupLeftIcon(writer, context, menuItem, classPrefix);
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)(classPrefix + "-lbl"), null);
        String label = menuItem.getLabel();
        if (label != null) {
            writer.writeText((Object)label, null);
        }
    }

    private void encodeHeaderGroupEnd(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        writer.endElement("td");
        this.encodeHeaderGroupRightIcon(writer, context, menuItem, classPrefix);
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    private PanelIcons.State getState(AbstractPanelMenuItem item) {
        return item.isDisabled() ? PanelIcons.State.commonDisabled : PanelIcons.State.common;
    }

    private void encodeHeaderGroupRightIcon(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        String icon = menuItem.isDisabled() ? menuItem.getRightDisabledIcon() : menuItem.getRightIcon();
        String cssClasses = this.concatClasses(classPrefix + "-exp-ico", menuItem.getLeftIconClass());
        if (icon == null || icon.trim().length() == 0) {
            icon = PanelIcons.transparent.toString();
        }
        this.encodeTdIcon(writer, context, cssClasses, icon, this.getState(menuItem));
    }

    private void encodeHeaderGroupLeftIcon(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        String icon = menuItem.isDisabled() ? menuItem.getLeftDisabledIcon() : menuItem.getLeftIcon();
        String cssClasses = this.concatClasses(classPrefix + "-ico", menuItem.getLeftIconClass());
        if (icon == null || icon.trim().length() == 0) {
            icon = PanelIcons.transparent.toString();
        }
        this.encodeTdIcon(writer, context, cssClasses, icon, this.getState(menuItem));
    }

    private boolean isIconRendered(String attrIconValue) {
        return attrIconValue != null && attrIconValue.trim().length() > 0 && !PanelIcons.none.toString().equals(attrIconValue);
    }

    public void encodeTdIcon(ResponseWriter writer, FacesContext context, String classPrefix, String attrIconValue, PanelIcons.State state) throws IOException {
        block3: {
            if (!this.isIconRendered(attrIconValue)) {
                return;
            }
            writer.startElement("td", null);
            try {
                PanelIcons icon = PanelIcons.valueOf((String)attrIconValue);
                writer.writeAttribute("class", (Object)this.concatClasses(classPrefix, state.getCssClass(icon)), null);
            }
            catch (IllegalArgumentException e) {
                writer.writeAttribute("class", (Object)classPrefix, null);
                if (attrIconValue == null || attrIconValue.trim().length() == 0) break block3;
                writer.startElement("img", null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.writeURIAttribute("src", (Object)RenderKitUtils.getResourceURL(attrIconValue, context), null);
                writer.endElement("img");
            }
        }
        writer.endElement("td");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        return this.concatClasses(this.getCssClass(menuItem, ""), PanelMenuItemRenderer.attributeAsString(component, "styleClass"), menuItem.isDisabled() ? this.getCssClass(menuItem, "-dis") : "", menuItem.isDisabled() ? PanelMenuItemRenderer.attributeAsString(component, "disabledClass") : "");
    }

    public String getCssClass(AbstractPanelMenuItem item, String postfix) {
        return (item.isTopItem() ? TOP_CSS_CLASS_PREFIX : CSS_CLASS_PREFIX) + postfix;
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.PanelMenuItem", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractPanelMenuItem panelMenuItem = (AbstractPanelMenuItem)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ajax", (Object)TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panelMenuItem));
        options.put("disabled", panelMenuItem.isDisabled());
        options.put("mode", panelMenuItem.getMode());
        options.put("name", panelMenuItem.getName());
        options.put("selectable", panelMenuItem.isSelectable());
        options.put("unselectable", panelMenuItem.isUnselectable());
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuItem, options, UNSELECT);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuItem, options, SELECT);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuItem, options, BEFORE_SELECT);
        return options;
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        this.encodeHeaderGroupEnd(writer, context, menuItem, this.getCssClass(menuItem, ""));
        super.doEncodeEnd(writer, context, component);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPanelMenuItem.class;
    }
}

