/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.renderkit.util.ColorUtils;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.Java2DAnimatedUserResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class ProgressBarAnimatedBackgroundImage
extends AbstractJava2DUserResource
implements Java2DAnimatedUserResource,
StateHolderResource {
    private static final int NUMBER_OF_FRAMES = 12;
    private static final Dimension DIMENSION = new Dimension(24, 48);
    private int frameNumber = 0;
    private Color basicColor;

    public ProgressBarAnimatedBackgroundImage() {
        super(ImageType.GIF, DIMENSION);
    }

    public boolean isLooped() {
        return true;
    }

    public int getFrameDelay() {
        return 1000;
    }

    public void startFramesSequence() {
        this.frameNumber = 0;
    }

    public boolean hasNextFrame() {
        return this.frameNumber < 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createMainStage() {
        Color progressbarBackgroundColor = this.basicColor;
        Color progressbarSpiralColor = ColorUtils.adjustLightness((Color)this.basicColor, (float)0.2f);
        Dimension dimension = this.getDimension();
        BufferedImage retVal = this.getImageType().createImage(dimension.width, dimension.height * 2);
        Graphics g = retVal.getGraphics();
        try {
            g.setColor(progressbarBackgroundColor);
            g.fillRect(0, 0, dimension.width, dimension.height * 2);
            g.setColor(progressbarSpiralColor);
            for (int k : new int[]{-24, 0, 24, 48, 72}) {
                g.fillPolygon(new int[]{0, 24, 24, 0}, new int[]{24 + k, k, 12 + k, 36 + k}, 4);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return retVal;
    }

    public void paint(Graphics2D g2d) {
        ++this.frameNumber;
        Dimension dimension = this.getDimension();
        BufferedImage mainStage = this.createMainStage();
        BufferedImage frame = mainStage.getSubimage(0, 48 - this.frameNumber * 2, dimension.width, dimension.height);
        g2d.drawImage(frame, null, null);
        Color progressbarShadowStartColor = ColorUtils.overwriteAlpha((Color)ColorUtils.adjustLightness((Color)this.basicColor, (float)0.7f), (float)0.6f);
        Color progressbarShadowEndColor = ColorUtils.overwriteAlpha((Color)ColorUtils.adjustLightness((Color)this.basicColor, (float)0.3f), (float)0.6f);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, progressbarShadowStartColor, 0.0f, 7.0f, progressbarShadowEndColor));
        g2d.fillRect(0, 0, dimension.width, 7);
    }

    public boolean isTransient() {
        return false;
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        Integer color = skin.getColorParameter(context, "selectControlColor");
        dataOutput.writeInt(color);
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.basicColor = new Color(dataInput.readInt());
    }
}

