/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.util.PanelIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableIconsRendererHelper<T extends UIComponent> {
    protected final String text;
    protected final String cssClassPrefix;
    protected final String cssIconsClassPrefix;

    protected TableIconsRendererHelper(String text, String cssClassPrefix, String cssIconsClassPrefix) {
        this.text = text;
        this.cssClassPrefix = cssClassPrefix;
        this.cssIconsClassPrefix = cssIconsClassPrefix;
    }

    protected TableIconsRendererHelper(String text, String cssClassPrefix) {
        this(text, cssClassPrefix, cssClassPrefix + "-ico");
    }

    public void encodeHeader(ResponseWriter writer, FacesContext context, T component) throws IOException {
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)(this.cssClassPrefix + "-gr"), null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        this.encodeHeaderLeftIcon(writer, context, component);
        this.encodeHeaderText(writer, context, component);
        this.encodeHeaderRightIcon(writer, context, component);
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeHeaderText(ResponseWriter writer, FacesContext context, T component) throws IOException {
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)(this.cssClassPrefix + "-lbl"), null);
        this.encodeHeaderTextValue(writer, context, component);
        writer.endElement("td");
    }

    protected void encodeHeaderTextValue(ResponseWriter writer, FacesContext context, T component) throws IOException {
        TableIconsRendererHelper.writeFacetOrAttr(writer, context, component, this.text, this.text);
    }

    public static void writeFacetOrAttr(ResponseWriter writer, FacesContext context, UIComponent component, String attr, String facetName) throws IOException {
        TableIconsRendererHelper.writeFacetOrAttr(writer, context, component, attr, component.getFacet(facetName));
    }

    public static void writeFacetOrAttr(ResponseWriter writer, FacesContext context, UIComponent component, String attr, UIComponent headerFacet) throws IOException {
        if (headerFacet != null && headerFacet.isRendered()) {
            headerFacet.encodeAll(context);
        } else {
            Object label = component.getAttributes().get(attr);
            if (label != null && !label.equals("")) {
                writer.writeText(label, null);
            }
        }
    }

    protected abstract void encodeHeaderLeftIcon(ResponseWriter var1, FacesContext var2, T var3) throws IOException;

    protected abstract void encodeHeaderRightIcon(ResponseWriter var1, FacesContext var2, T var3) throws IOException;

    protected void encodeTdIcon(ResponseWriter writer, FacesContext context, String cssClass, String attrIconCollapsedValue, String attrIconExpandedValue, PanelIcons.State state) throws IOException {
        if (this.isIconRendered(attrIconCollapsedValue) || this.isIconRendered(attrIconExpandedValue)) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)cssClass, null);
            if (this.isIconRendered(attrIconCollapsedValue)) {
                this.encodeIdIcon(writer, context, attrIconCollapsedValue, this.cssIconsClassPrefix + "-colps", state);
            }
            if (this.isIconRendered(attrIconExpandedValue)) {
                this.encodeIdIcon(writer, context, attrIconExpandedValue, this.cssIconsClassPrefix + "-exp", state);
            }
            writer.endElement("td");
        }
    }

    protected boolean isIconRendered(String attrIconValue) {
        return attrIconValue != null && attrIconValue.trim().length() > 0 && !PanelIcons.none.toString().equals(attrIconValue);
    }

    protected void encodeIdIcon(ResponseWriter writer, FacesContext context, String attrIconValue, String styleClass, PanelIcons.State state) throws IOException {
        if (attrIconValue == null || attrIconValue.trim().length() <= 0) {
            TableIconsRendererHelper.encodeDivIcon(writer, PanelIcons.none, styleClass, state);
        } else {
            PanelIcons icon = PanelIcons.getIcon((String)attrIconValue);
            if (icon != null) {
                TableIconsRendererHelper.encodeDivIcon(writer, icon, styleClass, state);
            } else {
                TableIconsRendererHelper.encodeImage(writer, context, attrIconValue, styleClass);
            }
        }
    }

    public static void encodeDivIcon(ResponseWriter writer, PanelIcons icon, String styleClass, PanelIcons.State state) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses(styleClass, state.getCssClass(icon)), null);
        writer.endElement("div");
    }

    public static void encodeImage(ResponseWriter writer, FacesContext context, String attrIconValue, String styleClass) throws IOException {
        writer.startElement("img", null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeURIAttribute("src", (Object)RenderKitUtils.getResourceURL(attrIconValue, context), null);
        writer.endElement("img");
    }
}

