/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public abstract class ArrowBase
extends AbstractJava2DUserResource
implements StateHolderResource {
    private int color;
    private String colorName = "generalTextColor";

    public ArrowBase(Dimension dimension) {
        super(dimension);
    }

    @PostConstructResource
    public void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        this.color = skin.getColorParameter(context, this.colorName);
    }

    protected final void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public void paint(Graphics2D graphics2d) {
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setColor(new Color(this.color));
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.color);
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.color = dataInput.readInt();
    }

    public boolean isTransient() {
        return false;
    }
}

