/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class TreePlusImage
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(16, 16);
    protected Integer generalColorValue;
    protected Integer controlColorValue;
    protected Integer trimColorValue;

    public TreePlusImage() {
        super(DIMENSION);
    }

    @PostConstructResource
    public void init() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        this.generalColorValue = skin.getColorParameter(context, "generalTextColor");
        this.controlColorValue = skin.getColorParameter(context, "controlBackgroundColor");
        this.trimColorValue = skin.getColorParameter(context, "trimColor");
    }

    protected void drawFrame(Graphics2D g2d) {
        Color trimColor = new Color(this.trimColorValue);
        Color controlColor = new Color(this.controlColorValue);
        g2d.setColor(trimColor);
        g2d.drawRect(3, 3, 8, 8);
        Rectangle2D.Float rect = new Rectangle2D.Float(4.0f, 4.0f, 7.0f, 7.0f);
        GradientPaint gragient = new GradientPaint(4.0f, 4.0f, controlColor, 13.0f, 13.0f, trimColor);
        g2d.setPaint(gragient);
        g2d.fill(rect);
    }

    public void paint(Graphics2D g2d) {
        this.drawFrame(g2d);
        this.drawHorizontalCrossLine(g2d);
        this.drawVerticalCrossLine(g2d);
    }

    protected void drawVerticalCrossLine(Graphics2D g2d) {
        g2d.setColor(new Color(this.generalColorValue));
        g2d.drawLine(7, 5, 7, 9);
    }

    protected void drawHorizontalCrossLine(Graphics2D g2d) {
        g2d.setColor(new Color(this.generalColorValue));
        g2d.drawLine(5, 7, 9, 7);
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.generalColorValue);
        dataOutput.writeInt(this.controlColorValue);
        dataOutput.writeInt(this.trimColorValue);
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.generalColorValue = dataInput.readInt();
        this.controlColorValue = dataInput.readInt();
        this.trimColorValue = dataInput.readInt();
    }

    public boolean isTransient() {
        return false;
    }
}

