/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.CharBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSEncoder;
import org.ajax4jsf.javascript.PropertyUtils;
import org.ajax4jsf.javascript.ResponseWriterWrapper;
import org.ajax4jsf.javascript.ScriptString;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptUtils {
    private static final Logger LOG = RichfacesLogger.UTIL.getLogger();
    private static final char[] CSS_SELECTOR_CHARS_TO_ESCAPE = ScriptUtils.createSortedCharArray("#;&,.+*~':\"!^$[]()=>|/");

    private ScriptUtils() {
    }

    private static char[] createSortedCharArray(String s) {
        char[] cs = s.toCharArray();
        Arrays.sort(cs);
        return cs;
    }

    private static void appendScript(Appendable appendable, Object obj, Map<Object, Boolean> cycleBusterMap) throws IOException {
        Boolean cycleBusterValue = cycleBusterMap.put(obj, Boolean.TRUE);
        if (cycleBusterValue != null) {
            if (LOG.isDebugEnabled()) {
                String formattedMessage;
                try {
                    formattedMessage = Messages.getMessage("JAVASCRIPT_CIRCULAR_REFERENCE", obj);
                }
                catch (MissingResourceException e) {
                    formattedMessage = MessageFormat.format("Circular reference serializing object to JS: {0}", obj);
                }
                LOG.debug(formattedMessage);
            }
            appendable.append("null");
        } else if (null == obj) {
            appendable.append("null");
        } else if (obj instanceof ScriptString) {
            ((ScriptString)obj).appendScript(appendable);
        } else if (obj.getClass().isArray()) {
            appendable.append("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    appendable.append(',');
                }
                ScriptUtils.appendScript(appendable, element, cycleBusterMap);
                first = false;
            }
            appendable.append("] ");
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            appendable.append("[");
            boolean first = true;
            for (Object element : collection) {
                if (!first) {
                    appendable.append(',');
                }
                ScriptUtils.appendScript(appendable, element, cycleBusterMap);
                first = false;
            }
            appendable.append("] ");
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            appendable.append("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    appendable.append(',');
                }
                ScriptUtils.appendEncodedString(appendable, entry.getKey());
                appendable.append(":");
                ScriptUtils.appendScript(appendable, entry.getValue(), cycleBusterMap);
                first = false;
            }
            appendable.append("} ");
        } else if (obj instanceof Number || obj instanceof Boolean) {
            appendable.append(obj.toString());
        } else if (obj instanceof String) {
            ScriptUtils.appendEncodedString(appendable, obj);
        } else if (obj instanceof Character) {
            ScriptUtils.appendEncodedString(appendable, obj);
        } else if (obj instanceof Enum) {
            ScriptUtils.appendEncodedString(appendable, obj);
        } else {
            PropertyDescriptor[] propertyDescriptors;
            appendable.append("{");
            try {
                propertyDescriptors = PropertyUtils.getPropertyDescriptors(obj);
            }
            catch (Exception e) {
                throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
            }
            boolean ignorePropertyReadException = obj.getClass().getName().startsWith("java.sql.");
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                Object propertyValue;
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                try {
                    propertyValue = PropertyUtils.readPropertyValue(obj, propertyDescriptor);
                }
                catch (Exception e) {
                    if (ignorePropertyReadException) continue;
                    throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
                }
                if (!first) {
                    appendable.append(',');
                }
                ScriptUtils.appendEncodedString(appendable, key);
                appendable.append(":");
                ScriptUtils.appendScript(appendable, propertyValue, cycleBusterMap);
                first = false;
            }
            appendable.append("} ");
        }
        if (cycleBusterValue == null) {
            cycleBusterMap.remove(obj);
        }
    }

    public static void writeToStream(ResponseWriter responseWriter, Object obj) throws IOException {
        ScriptUtils.appendScript(new ResponseWriterWrapper(responseWriter), obj, new IdentityHashMap<Object, Boolean>());
    }

    public static String toScript(Object obj) {
        StringBuilder sb = new StringBuilder();
        try {
            ScriptUtils.appendScript(sb, obj, new IdentityHashMap<Object, Boolean>());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void appendScript(Appendable appendable, Object obj) throws IOException {
        ScriptUtils.appendScript(appendable, obj, new IdentityHashMap<Object, Boolean>());
    }

    public static void appendEncodedString(Appendable appendable, Object obj) throws IOException {
        appendable.append("\"");
        ScriptUtils.appendEncoded(appendable, obj);
        appendable.append("\"");
    }

    public static void appendEncoded(Appendable appendable, Object obj) throws IOException {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                appendable.append(CharBuffer.wrap(encoder.encode(c)));
                continue;
            }
            appendable.append(c);
        }
    }

    public static String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static boolean shouldRenderAttribute(Object attributeVal) {
        if (null == attributeVal) {
            return false;
        }
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal.toString().length() == 0) {
            return false;
        }
        return ScriptUtils.isValidProperty(attributeVal);
    }

    public static boolean shouldRenderAttribute(String attributeName, Object attributeVal) {
        return ScriptUtils.shouldRenderAttribute(attributeVal);
    }

    public static boolean isValidProperty(Object property) {
        if (null == property) {
            return false;
        }
        if (property instanceof Integer && (Integer)property == Integer.MIN_VALUE) {
            return false;
        }
        if (property instanceof Double && (Double)property == Double.MIN_VALUE) {
            return false;
        }
        if (property instanceof Character && ((Character)property).charValue() == '\u0000') {
            return false;
        }
        if (property instanceof Float && ((Float)property).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (property instanceof Short && (Short)property == Short.MIN_VALUE) {
            return false;
        }
        if (property instanceof Byte && (Byte)property == -128) {
            return false;
        }
        return !(property instanceof Long) || (Long)property != Long.MIN_VALUE;
    }

    public static String escapeCSSMetachars(String s) {
        int idx;
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        int start = 0;
        int length = s.length();
        for (idx = 0; idx < length; ++idx) {
            char c = s.charAt(idx);
            int searchIdx = Arrays.binarySearch(CSS_SELECTOR_CHARS_TO_ESCAPE, c);
            if (searchIdx < 0) continue;
            builder.append(s.substring(start, idx));
            builder.append("\\");
            builder.append(c);
            start = idx + 1;
        }
        builder.append(s.substring(start, idx));
        return builder.toString();
    }
}

