/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import javax.faces.component.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentPredicates {
    private static final Predicate<UIComponent> IS_RENDERED = new Predicate<UIComponent>(){

        public boolean apply(UIComponent input) {
            return input.isRendered();
        }
    };

    private ComponentPredicates() {
    }

    public static Predicate<UIComponent> isRendered() {
        return IS_RENDERED;
    }

    public static Predicate<UIComponent> withId(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return new WithIdPredicate(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WithIdPredicate
    implements Predicate<UIComponent> {
        private final String id;

        public WithIdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(UIComponent input) {
            return this.id.equals(input.getId());
        }
    }
}

