/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.configuration;

import com.google.common.base.Strings;
import com.google.common.primitives.Primitives;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.richfaces.application.configuration.ConfigurationItem;
import org.richfaces.application.configuration.ConfigurationItemSource;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.configuration.ConstantValueExpression;
import org.richfaces.application.configuration.ValueExpressionHolder;
import org.richfaces.el.util.ELUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
implements ConfigurationService {
    private Map<Enum<?>, ValueExpressionHolder> itemsMap = new ConcurrentHashMap();

    private final ConfigurationItem getConfigurationItemAnnotation(Enum<?> enumKey) {
        try {
            ConfigurationItem item = enumKey.getClass().getField(enumKey.name()).getAnnotation(ConfigurationItem.class);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(MessageFormat.format("Cannot read @ConfigurationItem annotation from {0}.{1} because of {2}", enumKey.getClass().getName(), enumKey.name(), e.getMessage()));
        }
        throw new IllegalStateException(MessageFormat.format("Annotation @ConfigurationItem is not set at {0}.{1}", enumKey.getClass().getName(), enumKey.name()));
    }

    private <T> T coerce(FacesContext context, Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return targetType.cast(value);
        }
        if (value instanceof String) {
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            if (editor == null && Primitives.isWrapperType(targetType)) {
                editor = PropertyEditorManager.findEditor(Primitives.unwrap(targetType));
            }
            if (editor != null) {
                editor.setAsText((String)value);
                return targetType.cast(editor.getValue());
            }
            if (targetType.isEnum()) {
                return targetType.cast(Enum.valueOf(targetType, (String)value));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot convert {0} to object of {1} type", value, targetType.getName()));
    }

    protected ValueExpressionHolder createValueExpressionHolder(FacesContext context, Enum<?> key, Class<?> targetType) {
        String defaultValueString;
        ConfigurationItem annotation = this.getConfigurationItemAnnotation(key);
        ValueExpression expression = this.createValueExpression(context, annotation, targetType);
        Object defaultValue = null;
        if (!(expression != null && expression.isLiteralText() || Strings.isNullOrEmpty((String)(defaultValueString = annotation.defaultValue())))) {
            defaultValue = this.coerce(context, defaultValueString, targetType);
        }
        return new ValueExpressionHolder(expression, defaultValue);
    }

    private final ValueExpression createValueExpression(FacesContext context, ConfigurationItem annotation, Class<?> targetType) {
        ConfigurationItemSource source = annotation.source();
        if (source == ConfigurationItemSource.contextInitParameter) {
            for (String name : annotation.names()) {
                String value = context.getExternalContext().getInitParameter(name);
                if (Strings.isNullOrEmpty((String)value)) continue;
                if (!annotation.literal() && ELUtils.isValueReference((String)value)) {
                    ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
                    if (expressionFactory == null) {
                        throw new IllegalStateException("ExpressionFactory is null");
                    }
                    return expressionFactory.createValueExpression(context.getELContext(), value, targetType);
                }
                Object coercedValue = this.coerce(context, value, targetType);
                if (coercedValue == null) continue;
                return new ConstantValueExpression(coercedValue);
            }
            return null;
        }
        throw new IllegalArgumentException(source.toString());
    }

    protected <T> T getValue(FacesContext facesContext, Enum<?> key, Class<T> returnType) {
        ValueExpressionHolder holder = this.itemsMap.get(key);
        if (holder == null) {
            holder = this.createValueExpressionHolder(facesContext, key, returnType);
            this.itemsMap.put(key, holder);
        }
        return returnType.cast(holder.getValue(facesContext));
    }

    public Boolean getBooleanValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Boolean.class);
    }

    public Integer getIntValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Integer.class);
    }

    public Long getLongValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Long.class);
    }

    public String getStringValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, String.class);
    }

    public <T extends Enum<T>> T getEnumValue(FacesContext facesContext, Enum<?> key, Class<T> enumClass) {
        return (T)((Enum)this.getValue(facesContext, key, enumClass));
    }

    public Object getValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Object.class);
    }
}

