/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptUtils;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.websocket.WebSocketSupport;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.impl.ConsumingCollection;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequest
implements Request {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final String TOPIC_KEY = "topic";
    private static final String DATA_KEY = "data";
    private static final int SUSPEND_TIMEOUT = 30000;
    private final AtmosphereResourceEventListener resourceEventListener = new AtmosphereResourceEventListener(){

        public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            AbstractRequest.this.onSuspend();
        }

        public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            AbstractRequest.this.onResume();
        }

        public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            AbstractRequest.this.onDisconnect();
        }

        public void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            AbstractRequest.this.onBroadcast();
        }
    };
    private final AtmosphereResource<HttpServletRequest, HttpServletResponse> atmosphereResource;
    private final Session session;
    private final ExecutorService executorService;
    private final Queue<Message> messagesQueue = new ConcurrentLinkedQueue<Message>();
    private AtomicBoolean submitted = new AtomicBoolean(false);

    public AbstractRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> atmosphereResource, Session session, ExecutorService executorService) {
        this.atmosphereResource = atmosphereResource;
        ((AtmosphereEventLifecycle)atmosphereResource).addEventListener(this.resourceEventListener);
        this.session = session;
        this.executorService = executorService;
    }

    private void submitToWorker() {
        if (this.submitted.compareAndSet(false, true)) {
            this.executorService.submit(new FlushMessagesTask(this));
        }
    }

    private String serializeMessages() {
        return ScriptUtils.toScript(new ConsumingCollection<Message>(this.messagesQueue));
    }

    public void flushMessages() throws IOException {
        String serializedMessages = this.serializeMessages();
        PrintWriter writer = ((HttpServletResponse)this.atmosphereResource.getResponse()).getWriter();
        writer.write(serializedMessages);
        writer.flush();
        this.submitted.compareAndSet(true, false);
        if (this.isPolling()) {
            this.resume();
        } else if (!this.messagesQueue.isEmpty()) {
            this.submitToWorker();
        }
    }

    public void postMessage(TopicKey topicKey, String serializedMessage) {
        this.messagesQueue.add(new Message(topicKey, serializedMessage));
        this.submitToWorker();
    }

    public void suspend() throws IOException {
        this.atmosphereResource.suspend(30000L, this.isPolling());
    }

    public void resume() throws IOException {
        try {
            this.getSession().disconnect();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        this.atmosphereResource.resume();
    }

    public boolean isSuspended() {
        return this.atmosphereResource.getAtmosphereResourceEvent().isSuspended();
    }

    public boolean isPolling() {
        HttpServletRequest req = (HttpServletRequest)this.atmosphereResource.getRequest();
        boolean isWebsocket = req.getAttribute(WebSocketSupport.WEBSOCKET_SUSPEND) != null || req.getAttribute(WebSocketSupport.WEBSOCKET_RESUME) != null;
        return !isWebsocket;
    }

    public Session getSession() {
        return this.session;
    }

    protected AtmosphereResource<HttpServletRequest, HttpServletResponse> getResource() {
        return this.atmosphereResource;
    }

    protected void onSuspend() {
        try {
            this.getSession().connect((Request)this);
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    protected void onResume() {
        try {
            this.session.disconnect();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    protected void onDisconnect() {
        try {
            this.session.disconnect();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    protected void onBroadcast() {
    }

    private static final class FlushMessagesTask
    implements Runnable {
        private Request request;

        public FlushMessagesTask(Request request) {
            this.request = request;
        }

        public void run() {
            try {
                this.request.flushMessages();
            }
            catch (Throwable e) {
                LOGGER.error((CharSequence)e.getMessage(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Message
    implements ScriptString {
        private TopicKey topicKey;
        private String serializedData;

        public Message(TopicKey topicKey, String serializedData) {
            this.topicKey = topicKey;
            this.serializedData = serializedData;
        }

        public String toScript() {
            Map<String, Object> map = this.createScriptMap();
            return ScriptUtils.toScript(map);
        }

        private Map<String, Object> createScriptMap() {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put(AbstractRequest.TOPIC_KEY, this.topicKey.getTopicAddress());
            map.put(AbstractRequest.DATA_KEY, new JSLiteral(this.serializedData));
            return map;
        }

        public void appendScript(Appendable target) throws IOException {
            target.append(this.toScript());
        }

        public void appendScriptToStringBuilder(StringBuilder stringBuilder) {
            try {
                this.appendScript(stringBuilder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

