/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.impl.SessionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtmospherePushHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private static final ThreadFactory DAEMON_THREADS_FACTORY = new ThreadFactory(){
        private final AtomicInteger threadsCounter = new AtomicInteger();

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "rf-push-worker-thread-" + this.threadsCounter.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    };
    private static final String PUSH_SESSION_ID_PARAM = "pushSessionId";
    private SessionManager sessionManager = new SessionManagerImpl(DAEMON_THREADS_FACTORY);
    private ExecutorService worker = Executors.newCachedThreadPool(DAEMON_THREADS_FACTORY);

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource) throws IOException {
        HttpServletRequest req = (HttpServletRequest)resource.getRequest();
        HttpServletResponse resp = (HttpServletResponse)resource.getResponse();
        String pushSessionId = req.getParameter(PUSH_SESSION_ID_PARAM);
        Session session = null;
        if (pushSessionId != null) {
            session = this.getSessionManager().getPushSession(pushSessionId);
        }
        if (session == null) {
            resp.sendError(400);
            return;
        }
        resp.setContentType("text/plain");
        try {
            Request request = this.createRequest(resource, session);
            request.suspend();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
    }

    protected abstract Request createRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> var1, Session var2);

    protected ExecutorService getWorker() {
        return this.worker;
    }

    public void init(ServletConfig servletConfig) throws Exception {
    }

    public void destroy() throws Exception {
        this.sessionManager.destroy();
    }
}

