/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.push.PushContext;
import org.richfaces.application.push.SessionFactory;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.application.push.impl.AtmosphereHandlerProvider;
import org.richfaces.application.push.impl.jms.MessagingContext;
import org.richfaces.application.push.impl.jms.PushHandlerImpl;
import org.richfaces.application.push.impl.jms.TopicsContextImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushContextImpl
implements PushContext,
SystemEventListener,
AtmosphereHandlerProvider {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private MessagingContext messagingContext;
    private TopicsContext topicsContext;
    private PushHandlerImpl pushHandlerImpl;

    public TopicsContext getTopicsContext() {
        return this.topicsContext;
    }

    private String getApplicationName(FacesContext facesContext) {
        ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
        return servletContext.getContextPath();
    }

    public void init(FacesContext facesContext) {
        try {
            facesContext.getApplication().subscribeToEvent(PreDestroyApplicationEvent.class, (SystemEventListener)this);
            facesContext.getExternalContext().getApplicationMap().put(PushContext.INSTANCE_KEY_NAME, this);
            ConfigurationService configurationService = (ConfigurationService)ServiceTracker.getService(ConfigurationService.class);
            InitialContext initialContext = new InitialContext();
            NameParser nameParser = initialContext.getNameParser("");
            Name cnfName = nameParser.parse(configurationService.getStringValue(facesContext, (Enum)CoreConfiguration.Items.pushJMSConnectionFactory));
            Name topicsNamespace = nameParser.parse(configurationService.getStringValue(facesContext, (Enum)CoreConfiguration.Items.pushJMSTopicsNamespace));
            this.messagingContext = new MessagingContext(initialContext, cnfName, topicsNamespace, this.getApplicationName(facesContext), configurationService.getStringValue(facesContext, (Enum)CoreConfiguration.Items.pushJMSConnectionUsername), configurationService.getStringValue(facesContext, (Enum)CoreConfiguration.Items.pushJMSConnectionPassword));
            this.messagingContext.shareInstance(facesContext);
            this.messagingContext.start();
            this.topicsContext = new TopicsContextImpl(this.messagingContext);
            this.pushHandlerImpl = new PushHandlerImpl(this.messagingContext, this.topicsContext);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        if (this.messagingContext != null) {
            try {
                this.messagingContext.stop();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (this.pushHandlerImpl != null) {
            try {
                this.pushHandlerImpl.destroy();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreDestroyApplicationEvent)) {
            throw new IllegalArgumentException(event.getClass().getName());
        }
        this.destroy();
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public SessionFactory getSessionFactory() {
        return this.pushHandlerImpl;
    }

    @Override
    public AtmosphereHandler<HttpServletRequest, HttpServletResponse> getHandler() {
        return this.pushHandlerImpl;
    }

    public SessionManager getSessionManager() {
        return this.pushHandlerImpl.getSessionManager();
    }
}

