/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import java.util.concurrent.ExecutorService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.richfaces.application.push.MessageDataSerializer;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.MessageListener;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.application.push.impl.AbstractRequest;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
extends AbstractRequest
implements MessageListener {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private TopicsContext topicsContext;

    public RequestImpl(AtmosphereResource<HttpServletRequest, HttpServletResponse> atmosphereResource, Session session, ExecutorService executorService, TopicsContext topicsContext) {
        super(atmosphereResource, session, executorService);
        this.topicsContext = topicsContext;
    }

    private String serializeMessage(Topic topic, Message message) {
        String serializedMessageData = null;
        Object messageData = null;
        try {
            if (message instanceof ObjectMessage) {
                messageData = ((ObjectMessage)message).getObject();
            } else if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                if (message.getBooleanProperty("org_richfaces_push_SerializedData")) {
                    serializedMessageData = textMessage.getText();
                } else {
                    messageData = textMessage.getText();
                }
            }
        }
        catch (JMSException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        if (serializedMessageData != null) {
            return serializedMessageData;
        }
        if (messageData != null) {
            MessageDataSerializer messageDataSerializer = topic.getMessageDataSerializer();
            try {
                return messageDataSerializer.serialize(messageData);
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void onMessage(Object message) throws MessageException {
        Message jmsMessage = (Message)message;
        try {
            String topicName = ((javax.jms.Topic)jmsMessage.getJMSDestination()).getTopicName();
            Topic topic = this.topicsContext.getTopic(new TopicKey(topicName));
            if (topic == null) {
                return;
            }
            String serializedMessageData = this.serializeMessage(topic, jmsMessage);
            if (serializedMessageData == null) {
                return;
            }
            this.postMessage(new TopicKey(topicName, jmsMessage.getStringProperty("rf_push_subtopic")), serializedMessageData);
        }
        catch (JMSException e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
    }

    public MessageListener getMessageListener() {
        return this;
    }
}

