/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.richfaces.application.push.EventAbortedException;
import org.richfaces.application.push.MessageListener;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.SessionPreSubscriptionEvent;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicEvent;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.application.push.impl.AbstractSession;
import org.richfaces.application.push.impl.jms.MessagingContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
extends AbstractSession {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private final MessagingContext messagingContext;
    private final TopicsContext topicsContext;
    private final Multimap<TopicKey, TopicKey> successfulSubscriptions = ArrayListMultimap.create();
    private final Map<TopicKey, String> failedSubscriptions = Maps.newHashMap();
    private javax.jms.Session jmsSession;
    private Collection<TopicSubscriber> subscribers = Lists.newArrayListWithCapacity((int)1);

    public SessionImpl(String id, SessionManager sessionManager, MessagingContext messagingContext, TopicsContext topicsContext) {
        super(id, sessionManager);
        this.messagingContext = messagingContext;
        this.topicsContext = topicsContext;
    }

    public Map<TopicKey, String> getFailedSubscriptions() {
        return this.failedSubscriptions;
    }

    public Multimap<TopicKey, TopicKey> getSuccessfulSubscriptions() {
        return this.successfulSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSubscriptions(Iterable<TopicKey> topicKeys) {
        javax.jms.Session jmsSession = null;
        try {
            Multimap<TopicKey, TopicKey> rootTopicsMap = this.createRootTopicsKeysMap(topicKeys);
            jmsSession = this.messagingContext.createSession();
            for (Map.Entry<TopicKey, Collection<TopicKey>> entry : rootTopicsMap.asMap().entrySet()) {
                TopicSubscriber subscriber = null;
                try {
                    subscriber = this.messagingContext.createTopicSubscriber(this, jmsSession, entry);
                    this.successfulSubscriptions.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
                }
                finally {
                    if (subscriber == null) continue;
                    subscriber.close();
                }
            }
        }
        catch (JMSException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        finally {
            if (jmsSession != null) {
                try {
                    jmsSession.close();
                }
                catch (JMSException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Multimap<TopicKey, TopicKey> createRootTopicsKeysMap(Iterable<TopicKey> topicKeys) {
        ArrayListMultimap rootTopicKeys = ArrayListMultimap.create();
        for (TopicKey topicKey : topicKeys) {
            rootTopicKeys.put((Object)topicKey.getRootTopicKey(), (Object)topicKey);
        }
        return rootTopicKeys;
    }

    private void processFailedSubscriptions(Iterable<TopicKey> topicKeys) {
        Iterator<TopicKey> itr = topicKeys.iterator();
        while (itr.hasNext()) {
            TopicKey topicKey = itr.next();
            TopicKey rootTopicKey = topicKey.getRootTopicKey();
            Topic pushTopic = this.topicsContext.getTopic(rootTopicKey);
            try {
                pushTopic.publishEvent((TopicEvent)new SessionPreSubscriptionEvent(pushTopic, topicKey, (Session)this));
            }
            catch (EventAbortedException e) {
                itr.remove();
                this.failedSubscriptions.put(topicKey, e.getMessage());
            }
        }
    }

    @Override
    protected void processConnect(Request request) throws Exception {
        super.processConnect(request);
        this.jmsSession = this.messagingContext.createSession();
        JMSToPushListenerAdaptor jmsListener = new JMSToPushListenerAdaptor(request.getMessageListener());
        for (Map.Entry<TopicKey, Collection<TopicKey>> entry : this.getSuccessfulSubscriptions().asMap().entrySet()) {
            TopicSubscriber subscriber = this.messagingContext.createTopicSubscriber(this, this.jmsSession, entry);
            this.subscribers.add(subscriber);
            subscriber.setMessageListener((javax.jms.MessageListener)jmsListener);
        }
    }

    private void clearSubscribers() {
        if (this.jmsSession != null) {
            for (TopicSubscriber subscriber : this.subscribers) {
                try {
                    subscriber.close();
                }
                catch (JMSException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            this.subscribers.clear();
            try {
                this.jmsSession.close();
            }
            catch (JMSException e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
            this.jmsSession = null;
        }
    }

    @Override
    protected void processDisconnect() throws Exception {
        try {
            this.clearSubscribers();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        super.processDisconnect();
    }

    public void subscribe(String[] topics) {
        Iterable topicKeys = Iterables.transform((Iterable)Lists.newLinkedList(Arrays.asList(topics)), (Function)TopicKey.factory());
        this.processFailedSubscriptions(topicKeys);
        this.createSubscriptions(topicKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        super.destroy();
        javax.jms.Session localJMSSession = null;
        try {
            localJMSSession = this.messagingContext.createSession();
            this.messagingContext.removeTopicSubscriber(this, localJMSSession, this.successfulSubscriptions.keySet());
        }
        catch (JMSException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        finally {
            if (localJMSSession != null) {
                try {
                    localJMSSession.close();
                }
                catch (JMSException e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static final class JMSToPushListenerAdaptor
    implements javax.jms.MessageListener {
        private final MessageListener messageListener;

        private JMSToPushListenerAdaptor(MessageListener messageListener) {
            this.messageListener = messageListener;
        }

        public void onMessage(Message message) {
            try {
                this.messageListener.onMessage((Object)message);
                message.acknowledge();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

