/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import com.google.common.base.Strings;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.impl.AbstractTopic;
import org.richfaces.application.push.impl.jms.MessagingContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class TopicImpl
extends AbstractTopic {
    static final String SERIALIZED_DATA_INDICATOR = "org_richfaces_push_SerializedData";
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private MessagingContext messagingContext;

    public TopicImpl(TopicKey key, MessagingContext messagingContext) {
        super(key);
        this.messagingContext = messagingContext;
    }

    public void publish(String subtopic, Object messageData) throws MessageException {
        String serializedData = this.getMessageDataSerializer().serialize(messageData);
        Session session = null;
        try {
            session = this.messagingContext.createSession();
            MessageProducer producer = session.createProducer((Destination)this.messagingContext.lookup(this.getKey()));
            TextMessage textMessage = session.createTextMessage();
            textMessage.setText(serializedData);
            textMessage.setBooleanProperty(SERIALIZED_DATA_INDICATOR, true);
            if (!Strings.isNullOrEmpty((String)subtopic)) {
                textMessage.setStringProperty("rf_push_subtopic", subtopic);
            }
            producer.send((Message)textMessage);
        }
        catch (JMSException e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

