/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.context.ExecuteComponentCallback;
import org.richfaces.context.ExecuteExtendedVisitContext;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;
import org.richfaces.context.PartialViewExecuteVisitCallback;
import org.richfaces.context.RenderComponentCallback;
import org.richfaces.context.RenderExtendedVisitContext;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.ScriptsHolder;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.util.CoreAjaxRendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPartialViewContextImpl
extends ExtendedPartialViewContext {
    private static final Logger LOG = RichfacesLogger.CONTEXT.getLogger();
    private static final String ORIGINAL_WRITER = "org.richfaces.PartialViewContextImpl.ORIGINAL_WRITER";
    private ContextMode contextMode = null;
    private Collection<String> executeIds = null;
    private Collection<String> renderIds = null;
    private Collection<String> componentRenderIds = null;
    private Boolean renderAll = null;
    private String activatorComponentId = null;
    private String behaviorEvent = null;
    private boolean released = false;
    private boolean limitRender = false;
    private PartialViewContext wrappedViewContext;
    private String onbeforedomupdate;
    private String oncomplete;
    private Object responseData;

    public ExtendedPartialViewContextImpl(PartialViewContext wrappedViewContext, FacesContext facesContext) {
        super(facesContext);
        this.wrappedViewContext = wrappedViewContext;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.executeIds == null) {
                this.executeIds = new LinkedHashSet<String>();
                this.visitActivatorAtExecute();
            }
            return this.executeIds;
        }
        return this.wrappedViewContext.getExecuteIds();
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderIds == null) {
                this.renderIds = new LinkedHashSet<String>();
            }
            return this.renderIds;
        }
        return this.wrappedViewContext.getRenderIds();
    }

    public boolean isAjaxRequest() {
        this.assertNotReleased();
        return this.wrappedViewContext.isAjaxRequest();
    }

    public boolean isPartialRequest() {
        this.assertNotReleased();
        return this.wrappedViewContext.isPartialRequest();
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.assertNotReleased();
        this.wrappedViewContext.setPartialRequest(isPartialRequest);
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            return this.getExecuteIds().contains("@all");
        }
        return this.wrappedViewContext.isExecuteAll();
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderAll != null) {
                return this.renderAll;
            }
            return this.getRenderIds().contains("@all");
        }
        return this.wrappedViewContext.isRenderAll();
    }

    public void setRenderAll(boolean isRenderAll) {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            this.renderAll = isRenderAll;
        } else {
            this.wrappedViewContext.setRenderAll(isRenderAll);
        }
    }

    public PartialResponseWriter getPartialResponseWriter() {
        return this.wrappedViewContext.getPartialResponseWriter();
    }

    private boolean isProcessedExecutePhase(PhaseId phaseId) {
        return phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES;
    }

    public void processPartial(PhaseId phaseId) {
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                this.processPartialRenderPhase();
            } else if (this.isProcessedExecutePhase(phaseId)) {
                this.processPartialExecutePhase(phaseId);
            }
        } else {
            this.wrappedViewContext.processPartial(phaseId);
        }
    }

    protected void processPartialExecutePhase(PhaseId phaseId) {
        FacesContext facesContext = this.getFacesContext();
        PartialViewContext pvc = facesContext.getPartialViewContext();
        Collection executeIds = pvc.getExecuteIds();
        if (executeIds == null || executeIds.isEmpty()) {
            return;
        }
        try {
            this.executeComponents(phaseId, executeIds);
        }
        catch (Exception e) {
            LOG.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            ExternalContext externalContext = facesContext.getExternalContext();
            externalContext.setResponseCharacterEncoding(externalContext.getRequestCharacterEncoding());
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            facesContext.setResponseWriter((ResponseWriter)writer);
        }
    }

    protected void executeComponents(PhaseId phaseId, Collection<String> executeIds) {
        FacesContext facesContext = this.getFacesContext();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        ExecuteExtendedVisitContext visitContext = new ExecuteExtendedVisitContext(facesContext, executeIds, hints);
        PartialViewExecuteVisitCallback callback = new PartialViewExecuteVisitCallback(facesContext, phaseId);
        facesContext.getViewRoot().visitTree((VisitContext)visitContext, (VisitCallback)callback);
    }

    protected void processPartialRenderPhase() {
        FacesContext facesContext = this.getFacesContext();
        PartialViewContext pvc = facesContext.getPartialViewContext();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Collection phaseIds = pvc.getRenderIds();
        this.visitActivatorAtRender(phaseIds);
        try {
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            ResponseWriter orig = facesContext.getResponseWriter();
            facesContext.getAttributes().put(ORIGINAL_WRITER, orig);
            facesContext.setResponseWriter((ResponseWriter)writer);
            ExternalContext exContext = facesContext.getExternalContext();
            exContext.setResponseContentType("text/xml");
            exContext.addResponseHeader("Cache-Control", "no-cache");
            writer.startDocument();
            if (this.isRenderAll()) {
                this.renderAll(facesContext, viewRoot);
                this.renderState(facesContext);
                writer.endDocument();
                return;
            }
            if (phaseIds != null && !phaseIds.isEmpty() || !this.limitRender && PartialViewContextAjaxOutputTracker.hasNestedAjaxOutputs((UIComponent)viewRoot)) {
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
                RenderExtendedVisitContext visitContext = new RenderExtendedVisitContext(facesContext, (Collection<String>)phaseIds, hints, this.limitRender);
                RenderVisitCallback visitCallback = new RenderVisitCallback(facesContext);
                viewRoot.visitTree((VisitContext)visitContext, (VisitCallback)visitCallback);
            }
            this.renderState(facesContext);
            this.renderExtensions(facesContext, (UIComponent)viewRoot);
            writer.endDocument();
        }
        catch (IOException ex) {
            this.cleanupAfterView();
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            this.cleanupAfterView();
            throw ex;
        }
    }

    private void setupExecuteCallbackData(ExecuteComponentCallback callback) {
        this.executeIds.addAll(callback.getExecuteIds());
        this.setupRenderCallbackData(callback);
    }

    private void setupRenderCallbackData(RenderComponentCallback callback) {
        this.componentRenderIds = callback.getRenderIds();
        this.onbeforedomupdate = callback.getOnbeforedomupdate();
        this.oncomplete = callback.getOncomplete();
        this.responseData = callback.getData();
        this.limitRender = callback.isLimitRender();
    }

    private void visitActivatorAtExecute() {
        ExecuteComponentCallback callback = new ExecuteComponentCallback(this.getFacesContext(), this.behaviorEvent);
        if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.of(VisitHint.SKIP_UNRENDERED))) {
            this.setupExecuteCallbackData(callback);
            if (!this.executeIds.contains("@all")) {
                this.addImplicitExecuteIds(this.executeIds);
            }
        }
    }

    private void visitActivatorAtRender(Collection<String> ids) {
        if (!this.isRenderAll()) {
            RenderComponentCallback callback = new RenderComponentCallback(this.getFacesContext(), this.behaviorEvent);
            if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.noneOf(VisitHint.class))) {
                this.setupRenderCallbackData(callback);
            }
            if (this.componentRenderIds != null) {
                ids.addAll(this.componentRenderIds);
            }
            if (!Boolean.TRUE.equals(this.renderAll) && !ids.contains("@all")) {
                this.addImplicitRenderIds(ids, this.limitRender);
                this.appendOnbeforedomupdate(this.onbeforedomupdate);
                this.appendOncomplete(this.oncomplete);
                this.setResponseData(this.responseData);
            }
        }
    }

    private void renderAll(FacesContext context, UIViewRoot viewRoot) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewRoot");
        if (viewRoot.getChildCount() > 0) {
            for (UIComponent child : viewRoot.getChildren()) {
                child.encodeAll(context);
            }
        }
        writer.endUpdate();
    }

    private void renderState(FacesContext context) throws IOException {
        if (!context.getViewRoot().isTransient()) {
            PartialViewContext pvc = context.getPartialViewContext();
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            writer.startUpdate("javax.faces.ViewState");
            String state = context.getApplication().getStateManager().getViewState(context);
            writer.write(state);
            writer.endUpdate();
        }
    }

    public void release() {
        super.release();
        this.assertNotReleased();
        this.released = true;
        this.wrappedViewContext.release();
        this.wrappedViewContext = null;
        this.renderAll = null;
        this.executeIds = null;
        this.renderIds = null;
        this.limitRender = false;
        this.activatorComponentId = null;
        this.behaviorEvent = null;
        this.contextMode = null;
    }

    protected void addImplicitExecuteIds(Collection<String> ids) {
        UIViewRoot root;
        if (!ids.isEmpty() && (root = this.getFacesContext().getViewRoot()).getFacetCount() > 0 && root.getFacet("javax_faces_metadata") != null) {
            ids.add("javax_faces_metadata");
        }
    }

    protected void addImplicitRenderIds(Collection<String> ids, boolean limitRender) {
    }

    protected void renderExtensions(FacesContext context, UIComponent component) throws IOException {
        ScriptsHolder scriptsHolder = ((JavaScriptService)ServiceTracker.getService(JavaScriptService.class)).getScriptsHolder(context);
        for (Object script : scriptsHolder.getScripts()) {
            this.appendOncomplete(ScriptUtils.toScript(script));
        }
        for (Object script : scriptsHolder.getPageReadyScripts()) {
            this.appendOncomplete(ScriptUtils.toScript(script));
        }
        CoreAjaxRendererUtils.renderAjaxExtensions((FacesContext)context, (UIComponent)component);
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException("PartialViewContext already released!");
        }
    }

    private boolean visitActivatorComponent(String componentActivatorId, VisitCallback visitCallback, Set<VisitHint> visitHints) {
        FacesContext facesContext = this.getFacesContext();
        Set<String> idsToVisit = Collections.singleton(componentActivatorId);
        ExecuteExtendedVisitContext visitContext = new ExecuteExtendedVisitContext(facesContext, idsToVisit, visitHints);
        boolean visitResult = facesContext.getViewRoot().visitTree((VisitContext)visitContext, visitCallback);
        return visitResult;
    }

    private void cleanupAfterView() {
        FacesContext facesContext = this.getFacesContext();
        ResponseWriter orig = (ResponseWriter)facesContext.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        facesContext.setResponseWriter(orig);
    }

    protected ContextMode detectContextMode() {
        if (this.contextMode == null) {
            Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
            this.activatorComponentId = (String)requestParameterMap.get("org.richfaces.ajax.component");
            if (this.activatorComponentId != null) {
                this.contextMode = ContextMode.DIRECT;
                this.behaviorEvent = (String)requestParameterMap.get("javax.faces.behavior.event");
            } else {
                this.contextMode = ContextMode.WRAPPED;
            }
        }
        return this.contextMode;
    }

    private static final class RenderVisitCallback
    implements VisitCallback {
        private FacesContext ctx;

        private RenderVisitCallback(FacesContext ctx) {
            this.ctx = ctx;
        }

        private void logException(Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((CharSequence)e.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            String metaComponentId = (String)this.ctx.getAttributes().get("org.richfaces.MetaComponentId");
            if (metaComponentId != null) {
                MetaComponentEncoder encoder = (MetaComponentEncoder)target;
                try {
                    encoder.encodeMetaComponent(this.ctx, metaComponentId);
                }
                catch (Exception e) {
                    this.logException(e);
                }
            } else {
                PartialResponseWriter writer = this.ctx.getPartialViewContext().getPartialResponseWriter();
                try {
                    writer.startUpdate(target.getClientId(this.ctx));
                    try {
                        target.encodeAll(this.ctx);
                    }
                    catch (Exception ce) {
                        this.logException(ce);
                    }
                    writer.endUpdate();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            }
            return VisitResult.REJECT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContextMode {
        WRAPPED,
        DIRECT;

    }
}

