/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.ResourceParameter;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public class BaseGradient
extends AbstractJava2DUserResource
implements StateHolderResource {
    protected Integer headerBackgroundColor;
    protected Integer headerGradientColor;
    protected GradientType gradientType;
    private int width;
    private int height;
    private int gradientHeight;
    private String baseColor;
    private String gradientColor;
    private boolean horizontal;

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        super(null);
        this.setWidth(width);
        this.setHeight(height);
        this.setGradientHeight(gradientHeight);
        this.setBaseColorParam(baseColor);
        this.setGradientColorParam(gradientColor);
        this.setHorizontal(horizontal);
    }

    public BaseGradient(int width, int height, int gradientHeight) {
        this(width, height, gradientHeight, null, null, false);
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight, baseColor, gradientColor, false);
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height, baseColor, gradientColor);
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20, baseColor, gradientColor);
    }

    public BaseGradient(int width, int height, int gradientHeight, boolean horizontal) {
        this(width, height, gradientHeight, null, null, horizontal);
    }

    public BaseGradient(int width, int height, boolean horizontal) {
        this(width, height, horizontal ? width : height, null, null, horizontal);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, horizontal ? width : height, baseColor, gradientColor, horizontal);
    }

    public BaseGradient(boolean horizontal) {
        this(30, 50, 20, null, null, horizontal);
    }

    public BaseGradient(String baseColor, String gradientColor, boolean horizontal) {
        this(30, 50, 20, baseColor, gradientColor, horizontal);
    }

    protected void initializeProperties(FacesContext context, Skin skin) {
    }

    @PostConstructResource
    public final void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        String gradientTypeString = null;
        if (gradientTypeString == null || gradientTypeString.length() == 0) {
            gradientTypeString = (String)skin.getParameter(context, "gradientType");
        }
        this.gradientType = GradientType.getByParameter(gradientTypeString);
        this.initializeProperties(context, skin);
        this.headerBackgroundColor = skin.getColorParameter(context, this.baseColor);
        this.headerGradientColor = skin.getColorParameter(context, this.gradientColor);
    }

    @ResourceParameter(defaultValue="30")
    public final void setWidth(int width) {
        this.width = width;
    }

    @ResourceParameter(defaultValue="50")
    public final void setHeight(int height) {
        this.height = height;
    }

    @ResourceParameter(defaultValue="20")
    public final void setGradientHeight(int gradientHeight) {
        this.gradientHeight = gradientHeight;
    }

    @ResourceParameter(defaultValue="headerBackgroundColor")
    public final void setBaseColorParam(String paramName) {
        this.baseColor = paramName;
    }

    @ResourceParameter(defaultValue="headerGradientColor")
    public final void setGradientColorParam(String paramName) {
        this.gradientColor = paramName;
    }

    @ResourceParameter(defaultValue="false")
    public final void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public final void setGradientType(GradientType gradientType) {
        this.gradientType = gradientType;
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    protected int getGradientHeight() {
        return this.gradientHeight;
    }

    protected int getHeight() {
        return this.height;
    }

    protected int getWidth() {
        return this.width;
    }

    protected String getBaseColor() {
        return this.baseColor;
    }

    protected String getGradientColor() {
        return this.gradientColor;
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    protected void drawGradient(Graphics2D g2d, Shape shape, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(shape);
        }
    }

    public void paint(Graphics2D graphics2d) {
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.paintGradient(graphics2d, this.getDimension());
    }

    protected void paintGradient(Graphics2D g2d, Dimension dim) {
        if ((this.headerBackgroundColor != null || this.headerGradientColor != null) && this.gradientType != null) {
            int localGradientHeight;
            GradientType.BiColor biColor = new GradientType.BiColor(this.headerBackgroundColor, this.headerGradientColor);
            GradientType.BiColor firstLayer = this.gradientType.getFirstLayerColors(biColor);
            GradientType.BiColor secondLayer = this.gradientType.getSecondLayerColors(biColor);
            if (this.horizontal) {
                g2d.transform(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
                dim.setSize(dim.height, dim.width);
            }
            if ((localGradientHeight = this.gradientHeight) < 0) {
                localGradientHeight = dim.height;
            }
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            this.drawGradient(g2d, rect, firstLayer, localGradientHeight);
            int smallGradientHeight = localGradientHeight / 2;
            rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, smallGradientHeight);
            this.drawGradient(g2d, rect, secondLayer, smallGradientHeight);
        }
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.width = dataInput.readShort();
        this.height = dataInput.readShort();
        this.gradientHeight = dataInput.readShort();
        this.horizontal = dataInput.readBoolean();
        this.headerBackgroundColor = dataInput.readInt();
        this.headerGradientColor = dataInput.readInt();
        this.gradientType = GradientType.values()[dataInput.readByte()];
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort((short)this.width);
        dataOutput.writeShort((short)this.height);
        dataOutput.writeShort((short)this.gradientHeight);
        dataOutput.writeBoolean(this.horizontal);
        dataOutput.writeInt(this.headerBackgroundColor);
        dataOutput.writeInt(this.headerGradientColor);
        dataOutput.writeByte((byte)this.gradientType.ordinal());
    }

    public boolean isTransient() {
        return false;
    }
}

