/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.richfaces.context.ComponentIdResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoreRendererUtils {
    public static final Set<String> GLOBAL_META_COMPONENTS = new HashSet<String>(2);
    public static final CoreRendererUtils INSTANCE;

    private CoreRendererUtils() {
    }

    public String getPredefinedMetaComponentId(FacesContext facesContext, UIComponent component, String id) {
        UIForm nestingForm;
        if ("@all".equals(id)) {
            return "@all";
        }
        if ("@none".equals(id)) {
            return "@none";
        }
        if ("@this".equals(id)) {
            String metaComponentId = (String)facesContext.getAttributes().get("org.richfaces.MetaComponentId");
            if (metaComponentId != null) {
                return component.getClientId(facesContext) + '@' + metaComponentId;
            }
            return component.getClientId(facesContext);
        }
        if ("@form".equals(id) && (nestingForm = this.getNestingForm(facesContext, component)) != null) {
            return nestingForm.getClientId(facesContext);
        }
        return null;
    }

    private static boolean checkKeyword(Collection<String> ids, String keyword) {
        if (ids.contains(keyword)) {
            if (ids.size() != 1) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public Collection<String> findComponentsFor(FacesContext context, UIComponent component, Collection<String> shortIds) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(shortIds.size());
        if (CoreRendererUtils.checkKeyword(shortIds, "@all")) {
            result.add("@all");
        } else if (!CoreRendererUtils.checkKeyword(shortIds, "@none")) {
            ComponentIdResolver locator = new ComponentIdResolver(context);
            for (String id : shortIds) {
                String predefinedMetaComponentId = this.getPredefinedMetaComponentId(context, component, id);
                if (predefinedMetaComponentId != null) {
                    if (GLOBAL_META_COMPONENTS.contains(predefinedMetaComponentId)) {
                        result.clear();
                        result.add(predefinedMetaComponentId);
                        break;
                    }
                    result.add(predefinedMetaComponentId);
                    continue;
                }
                locator.addId(id);
            }
            locator.resolve(component);
            result.addAll(locator.getResolvedIds());
        }
        return result;
    }

    public UIForm getNestingForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm nestingForm = null;
        if (parent != null) {
            nestingForm = (UIForm)parent;
        }
        return nestingForm;
    }

    static {
        GLOBAL_META_COMPONENTS.add("@all");
        GLOBAL_META_COMPONENTS.add("@none");
        INSTANCE = new CoreRendererUtils();
    }
}

