/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.UIInputNumber;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class HtmlInputNumberSpinner extends UIInputNumber
    implements ClientBehaviorHolder    {

    public static final String COMPONENT_TYPE="org.richfaces.InputNumberSpinner";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlInputNumberSpinner() {
        super();
        setRendererType("org.richfaces.InputNumberSpinnerRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "click",
        "blur",
        "upclick",
        "mouseover",
        "mousemove",
        "inputkeyup",
        "inputclick",
        "mouseout",
        "inputmouseover",
        "inputmousemove",
        "inputkeydown",
        "dblclick",
        "inputmouseup",
        "inputmouseout",
        "focus",
        "inputkeypress",
        "downclick",
        "select",
        "inputmousedown",
        "mouseup",
        "change",
        "inputdblclick"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }


    protected enum Properties {
        accesskey,
        cycled,
        disabled,
        enableManualInput,
        inputClass,
        inputSize,
        maxValue,
        minValue,
        onblur,
        onchange,
        onclick,
        ondblclick,
        ondownclick,
        onfocus,
        oninputclick,
        oninputdblclick,
        oninputkeydown,
        oninputkeypress,
        oninputkeyup,
        oninputmousedown,
        oninputmousemove,
        oninputmouseout,
        oninputmouseover,
        oninputmouseup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onselect,
        onupclick,
        step,
        style,
        styleClass,
        tabindex
        
    }


 
    public String getAccesskey() {
        String value = (String) getStateHelper().eval(Properties.accesskey);
        return value;
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
    }

 
    public boolean isCycled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.cycled, true);
        return value;
    }
    
    public void setCycled(boolean cycled) {
        getStateHelper().put(Properties.cycled, cycled);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public boolean isEnableManualInput() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.enableManualInput, true);
        return value;
    }
    
    public void setEnableManualInput(boolean enableManualInput) {
        getStateHelper().put(Properties.enableManualInput, enableManualInput);
    }

 
    public String getInputClass() {
        String value = (String) getStateHelper().eval(Properties.inputClass);
        return value;
    }
    
    public void setInputClass(String inputClass) {
        getStateHelper().put(Properties.inputClass, inputClass);
    }

 
    public int getInputSize() {
        Integer value = (Integer) getStateHelper().eval(Properties.inputSize, 10);
        return value;
    }
    
    public void setInputSize(int inputSize) {
        getStateHelper().put(Properties.inputSize, inputSize);
    }

 
    public String getMaxValue() {
        String value = (String) getStateHelper().eval(Properties.maxValue, "100");
        return value;
    }
    
    public void setMaxValue(String maxValue) {
        getStateHelper().put(Properties.maxValue, maxValue);
    }

 
    public String getMinValue() {
        String value = (String) getStateHelper().eval(Properties.minValue, "0");
        return value;
    }
    
    public void setMinValue(String minValue) {
        getStateHelper().put(Properties.minValue, minValue);
    }

 
    public String getOnblur() {
        String value = (String) getStateHelper().eval(Properties.onblur);
        return value;
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnchange() {
        String value = (String) getStateHelper().eval(Properties.onchange);
        return value;
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOndownclick() {
        String value = (String) getStateHelper().eval(Properties.ondownclick);
        return value;
    }
    
    public void setOndownclick(String ondownclick) {
        getStateHelper().put(Properties.ondownclick, ondownclick);
    }

 
    public String getOnfocus() {
        String value = (String) getStateHelper().eval(Properties.onfocus);
        return value;
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOninputclick() {
        String value = (String) getStateHelper().eval(Properties.oninputclick);
        return value;
    }
    
    public void setOninputclick(String oninputclick) {
        getStateHelper().put(Properties.oninputclick, oninputclick);
    }

 
    public String getOninputdblclick() {
        String value = (String) getStateHelper().eval(Properties.oninputdblclick);
        return value;
    }
    
    public void setOninputdblclick(String oninputdblclick) {
        getStateHelper().put(Properties.oninputdblclick, oninputdblclick);
    }

 
    public String getOninputkeydown() {
        String value = (String) getStateHelper().eval(Properties.oninputkeydown);
        return value;
    }
    
    public void setOninputkeydown(String oninputkeydown) {
        getStateHelper().put(Properties.oninputkeydown, oninputkeydown);
    }

 
    public String getOninputkeypress() {
        String value = (String) getStateHelper().eval(Properties.oninputkeypress);
        return value;
    }
    
    public void setOninputkeypress(String oninputkeypress) {
        getStateHelper().put(Properties.oninputkeypress, oninputkeypress);
    }

 
    public String getOninputkeyup() {
        String value = (String) getStateHelper().eval(Properties.oninputkeyup);
        return value;
    }
    
    public void setOninputkeyup(String oninputkeyup) {
        getStateHelper().put(Properties.oninputkeyup, oninputkeyup);
    }

 
    public String getOninputmousedown() {
        String value = (String) getStateHelper().eval(Properties.oninputmousedown);
        return value;
    }
    
    public void setOninputmousedown(String oninputmousedown) {
        getStateHelper().put(Properties.oninputmousedown, oninputmousedown);
    }

 
    public String getOninputmousemove() {
        String value = (String) getStateHelper().eval(Properties.oninputmousemove);
        return value;
    }
    
    public void setOninputmousemove(String oninputmousemove) {
        getStateHelper().put(Properties.oninputmousemove, oninputmousemove);
    }

 
    public String getOninputmouseout() {
        String value = (String) getStateHelper().eval(Properties.oninputmouseout);
        return value;
    }
    
    public void setOninputmouseout(String oninputmouseout) {
        getStateHelper().put(Properties.oninputmouseout, oninputmouseout);
    }

 
    public String getOninputmouseover() {
        String value = (String) getStateHelper().eval(Properties.oninputmouseover);
        return value;
    }
    
    public void setOninputmouseover(String oninputmouseover) {
        getStateHelper().put(Properties.oninputmouseover, oninputmouseover);
    }

 
    public String getOninputmouseup() {
        String value = (String) getStateHelper().eval(Properties.oninputmouseup);
        return value;
    }
    
    public void setOninputmouseup(String oninputmouseup) {
        getStateHelper().put(Properties.oninputmouseup, oninputmouseup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnselect() {
        String value = (String) getStateHelper().eval(Properties.onselect);
        return value;
    }
    
    public void setOnselect(String onselect) {
        getStateHelper().put(Properties.onselect, onselect);
    }

 
    public String getOnupclick() {
        String value = (String) getStateHelper().eval(Properties.onupclick);
        return value;
    }
    
    public void setOnupclick(String onupclick) {
        getStateHelper().put(Properties.onupclick, onupclick);
    }

 
    public String getStep() {
        String value = (String) getStateHelper().eval(Properties.step, "1");
        return value;
    }
    
    public void setStep(String step) {
        getStateHelper().put(Properties.step, step);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public int getTabindex() {
        Integer value = (Integer) getStateHelper().eval(Properties.tabindex, Integer.MIN_VALUE);
        return value;
    }
    
    public void setTabindex(int tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
    }


}