package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;
import org.richfaces.renderkit.TreeNodeRendererBase;


public class TreeNodeRenderer extends TreeNodeRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES34 = attributes()
	     .generic("align","align")
	     

	     .generic("dir","dir")
	     

	     .generic("id","id")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
private static boolean isEmpty(Object object) 
 {
		return object == null;
	}
	
@Override
public void encodeBegin(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
org.richfaces.renderkit.TreeNodeState nodeState  =  this.getNodeState(facesContext); 
UIComponent tree  =  this.getTreeComponent(component); 
addClientEventHandlers(facesContext, component);
responseWriter.startElement("div", component); 
   {
      Object value = this.concatClasses("rf-trn",component.getAttributes().get("styleClass"),tree.getAttributes().get("nodeClass"));
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES34);

UIComponent loadingFacet  =  this.getHandleLoadingFacetIfApplicable(component); 
	if (((!isEmpty(loadingFacet)) && convertToBoolean(loadingFacet.isRendered()))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-trn-hnd-ldn-fct",null);


	
                    loadingFacet.encodeAll(facesContext);
                ;
	responseWriter.endElement("span"); 
}
responseWriter.startElement("span", component); 
   {
      Object value = this.concatClasses(nodeState.getHandleClass(),component.getAttributes().get("handleClass"),tree.getAttributes().get("handleClass"));
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


responseWriter.endElement("span"); 
responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-trn-cnt",null);


encodeIcon(facesContext, component);
responseWriter.startElement("span", component); 
   {
      Object value = this.concatClasses("rf-trn-lbl",component.getAttributes().get("labelClass"),tree.getAttributes().get("labelClass"));
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }



	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.endElement("span"); 
responseWriter.endElement("span"); 
responseWriter.endElement("div"); 

	}
}

