/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.websocket.WebSocketSupport;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.impl.MessageDataScriptString;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request,
AtmosphereResourceEventListener {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final int SUSPEND_TIMEOUT = 30000;
    private Session session;
    private final Meteor meteor;
    private boolean hasActiveBroadcaster = false;
    private BroadcasterLifeCyclePolicy policy;

    public RequestImpl(Meteor meteor, Session session) {
        this.meteor = meteor;
        meteor.addListener((AtmosphereResourceEventListener)this);
        this.session = session;
        this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        this.meteor.getBroadcaster().setBroadcasterLifeCyclePolicy(this.policy);
    }

    public void suspend() {
        this.meteor.suspend(30000L, this.isPolling());
    }

    public void resume() {
        this.meteor.resume();
    }

    public boolean isPolling() {
        HttpServletRequest req = (HttpServletRequest)this.meteor.getAtmosphereResource().getRequest();
        boolean isWebsocket = req.getAttribute(WebSocketSupport.WEBSOCKET_SUSPEND) != null || req.getAttribute(WebSocketSupport.WEBSOCKET_RESUME) != null;
        return !isWebsocket;
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized void postMessages() {
        if (!this.hasActiveBroadcaster && !this.session.getMessages().isEmpty()) {
            this.hasActiveBroadcaster = true;
            this.meteor.getBroadcaster().broadcast((Object)new MessageDataScriptString(this.getSession().getMessages()));
        }
    }

    public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        try {
            this.getSession().connect((Request)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disconnect() {
        try {
            this.getSession().disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.disconnect();
    }

    public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        this.disconnect();
    }

    public synchronized void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        MessageDataScriptString serializedMessages = (MessageDataScriptString)((Object)event.getMessage());
        this.getSession().clearBroadcastedMessages(serializedMessages.getLastSequenceNumber());
        this.hasActiveBroadcaster = false;
        if (this.isPolling()) {
            event.getResource().resume();
        } else {
            this.postMessages();
        }
    }

    public void onThrowable(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        Throwable throwable = event.throwable();
        LOGGER.error((CharSequence)throwable.getMessage(), throwable);
    }
}

