/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import java.util.Date;
import java.util.HashMap;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.richfaces.cache.Cache;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheCache
implements Cache {
    private static final Logger LOGGER = RichfacesLogger.CACHE.getLogger();
    private static final String RESOURCE = "resource";
    private org.jboss.cache.Cache<String, Object> cache;

    public JBossCacheCache(org.jboss.cache.Cache<String, Object> cache) {
        this.cache = cache;
    }

    private Fqn<Object> createFqn(Object key) {
        return Fqn.fromElements((Object[])new Object[]{key});
    }

    public Object get(Object key) {
        return this.cache.get(this.createFqn(key), (Object)RESOURCE);
    }

    public void put(Object key, Object value, Date expired) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put(RESOURCE, value);
        if (expired != null) {
            map.put("expiration", expired.getTime());
        }
        this.cache.put(this.createFqn(key), map);
        Transaction transaction = this.cache.getInvocationContext().getTransaction();
        try {
            if (transaction != null && transaction.getStatus() == 0) {
                transaction.commit();
            }
        }
        catch (SystemException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (RollbackException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (HeuristicMixedException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public void start() {
        this.cache.start();
    }

    public void stop() {
        this.cache.stop();
    }
}

