/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class ResourceServlet
implements Servlet {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final String JAVAX_FACES_RESOURCE_IDENTIFIER = "/javax.faces.resource/";
    private static final Library[] LIBRARIES_TO_SERVE = new Library[]{new CKEditorLibrary(), new RichFacesImageLibrary()};
    private ServletConfig servletConfig;
    private FacesServlet facesServlet;

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        this.facesServlet = new FacesServlet();
        this.facesServlet.init(config);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void destroy() {
        this.facesServlet.destroy();
        this.facesServlet = null;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletResponse res;
        HttpServletRequest req;
        try {
            req = (HttpServletRequest)request;
            res = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
        this.httpService(req, res);
    }

    private void httpService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.handleRequestByEditorResourceServlet(request)) {
            this.facesServlet.service((ServletRequest)request, (ServletResponse)response);
        } else {
            ResourceServlet.sendResourceNotFound(response);
        }
    }

    private boolean handleRequestByEditorResourceServlet(HttpServletRequest request) {
        String resourcePath = ResourceServlet.getResourcePathFromRequest(request);
        for (Library library : LIBRARIES_TO_SERVE) {
            if (!library.allowServerRequest(resourcePath, request)) continue;
            return true;
        }
        return false;
    }

    private static String getResourcePathFromRequest(HttpServletRequest request) {
        String resourceName = ResourceServlet.decodeResourceURL(request);
        if (resourceName != null) {
            if (resourceName.startsWith(JAVAX_FACES_RESOURCE_IDENTIFIER)) {
                return resourceName.substring(JAVAX_FACES_RESOURCE_IDENTIFIER.length());
            }
            if (resourceName.startsWith("/rfRes/")) {
                return resourceName;
            }
            return null;
        }
        LOGGER.warn((CharSequence)("Resource key not found" + resourceName));
        return null;
    }

    private static String decodeResourceURL(HttpServletRequest request) {
        String resourceName = null;
        String facesMapping = ResourceServlet.getMappingForRequest(request);
        if (facesMapping != null) {
            if (facesMapping.startsWith("/")) {
                resourceName = request.getPathInfo();
            } else {
                String requestServletPath = request.getServletPath();
                resourceName = requestServletPath.substring(0, requestServletPath.length() - facesMapping.length());
            }
        }
        return resourceName;
    }

    private static void sendResourceNotFound(HttpServletResponse response) {
        response.setStatus(404);
    }

    private static String getMappingForRequest(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/";
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return servletPath;
        }
        int idx = servletPath.lastIndexOf(46);
        if (idx < 0) {
            return servletPath;
        }
        return servletPath.substring(idx);
    }

    private static class RichFacesImageLibrary
    implements Library {
        private Set<String> ALLOWED_PARAMETERS = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList("ln", "db", "v")));

        private RichFacesImageLibrary() {
        }

        public boolean allowServerRequest(String resourcePath, HttpServletRequest request) {
            if (resourcePath.startsWith("/rfRes/")) {
                if ((resourcePath = resourcePath.substring("/rfRes/".length())).contains("/")) {
                    return false;
                }
                if (!resourcePath.endsWith(".png")) {
                    return false;
                }
                if (!"org.richfaces.images".equals(request.getParameter("ln"))) {
                    return false;
                }
                Enumeration parameters = request.getParameterNames();
                while (parameters.hasMoreElements()) {
                    String parameter = (String)parameters.nextElement();
                    if (this.ALLOWED_PARAMETERS.contains(parameter)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class CKEditorLibrary
    implements Library {
        private Set<String> ALLOWED_PARAMETERS = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList("t", "db")));

        private CKEditorLibrary() {
        }

        public boolean allowServerRequest(String resourcePath, HttpServletRequest request) {
            if (resourcePath.startsWith("org.richfaces.ckeditor/")) {
                Enumeration parameters = request.getParameterNames();
                while (parameters.hasMoreElements()) {
                    String parameter = (String)parameters.nextElement();
                    if (this.ALLOWED_PARAMETERS.contains(parameter)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static interface Library {
        public boolean allowServerRequest(String var1, HttpServletRequest var2);
    }
}

