/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.webapp;

import java.text.MessageFormat;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.richfaces.webapp.GenericServletContainerInitializer;
import org.richfaces.webapp.ResourceServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceServletContainerInitializer
extends GenericServletContainerInitializer {
    private static final String SKIP_SERVLET_REGISTRATION_PARAM = "org.richfaces.resources.skipResourceServletRegistration";
    public static final String EDITOR_RESOURCES_DEFAULT_MAPPING = "/org.richfaces.resources/*";

    public void onStartup(Set<Class<?>> c, ServletContext servletContext) throws ServletException {
        if (Boolean.valueOf(servletContext.getInitParameter(SKIP_SERVLET_REGISTRATION_PARAM)).booleanValue()) {
            return;
        }
        try {
            ServletRegistration servletRegistration = this.getServletRegistration(ResourceServlet.class, servletContext);
            if (servletRegistration == null) {
                ResourceServletContainerInitializer.registerServlet(servletContext);
            }
        }
        catch (Exception e) {
            servletContext.log(MessageFormat.format("Exception registering RichFaces Resource Servlet: {0]", e.getMessage()), (Throwable)e);
        }
    }

    private static void registerServlet(ServletContext context) {
        ServletRegistration.Dynamic dynamicRegistration = context.addServlet("AutoRegisteredEditorResourceServlet", ResourceServlet.class);
        dynamicRegistration.addMapping(new String[]{EDITOR_RESOURCES_DEFAULT_MAPPING});
    }
}

