/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.validator.GraphValidatorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphValidator
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";
    private static final Logger LOG = RichfacesLogger.COMPONENTS.getLogger();

    @Attribute
    public abstract Object getValue();

    public abstract void setValue(Object var1);

    @Attribute
    public abstract String getSummary();

    public abstract void setSummary(String var1);

    @Attribute
    public abstract Class<?>[] getGroups();

    public abstract void setGroups(Class<?>[] var1);

    @Attribute(defaultValue="org.richfaces.BeanValidator")
    public abstract String getType();

    public abstract void setType(String var1);

    public void processDecodes(FacesContext context) {
        GraphValidatorState validatorState = null;
        boolean wasActive = false;
        Object value = this.getValue();
        if (null != value) {
            validatorState = GraphValidatorState.getState((FacesContext)context, (Object)value);
            if (null != validatorState) {
                wasActive = validatorState.isActive();
                validatorState.setActive(true);
            } else if (value instanceof Cloneable) {
                try {
                    Method method = this.getCloneMethod(value.getClass());
                    validatorState = new GraphValidatorState(method.invoke(value, new Object[0]));
                    validatorState.setActive(true);
                    GraphValidatorState.setState((FacesContext)context, (Object)value, (GraphValidatorState)validatorState);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        super.processDecodes(context);
        if (null != validatorState) {
            validatorState.setActive(wasActive);
        }
    }

    private Method getCloneMethod(Class<?> clazz) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (null != clazz.getSuperclass()) {
                Method method = this.getCloneMethod(clazz.getSuperclass());
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                return method;
            }
            throw e;
        }
    }

    protected GraphValidatorState getValidatorState(FacesContext context) {
        Object value = this.getValue();
        if (null != value) {
            return GraphValidatorState.getState((FacesContext)context, (Object)value);
        }
        return null;
    }

    public void processValidators(FacesContext context) {
        GraphValidatorState validatorState = this.getValidatorState(context);
        if (null != validatorState) {
            boolean wasActive = validatorState.isActive();
            validatorState.setActive(true);
            super.processValidators(context);
            validatorState.setActive(wasActive);
            if (!context.isValidationFailed()) {
                this.validateObject(context, validatorState.getCloned());
            }
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        Object value;
        super.processUpdates(context);
        if (!context.isValidationFailed() && null != (value = this.getValue()) && null == GraphValidatorState.getState((FacesContext)context, (Object)value)) {
            this.validateObject(context, value);
        }
    }

    private void validateObject(FacesContext context, Object value) {
        BeanValidatorService validatorService;
        Collection messages;
        if (null != value && !(messages = (validatorService = (BeanValidatorService)ServiceTracker.getService(BeanValidatorService.class)).validateObject(context, value, (Class[])this.getGroups())).isEmpty()) {
            context.renderResponse();
            String clientId = this.getClientId(context);
            for (String msg : messages) {
                String summary = null != this.getSummary() ? this.getSummary() : msg;
                context.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg));
            }
        }
    }

    public Validator createChildrenValidator() {
        FacesBeanValidator validator = (FacesBeanValidator)this.getFacesContext().getApplication().createValidator(this.getType());
        validator.setSummary(this.getSummary());
        ValueExpression expression = this.getValueExpression("groups");
        if (null != expression) {
            validator.setGroups(expression);
        } else {
            validator.setGroups(this.getGroups());
        }
        return validator;
    }
}

