/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractColumn;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;
import org.richfaces.renderkit.SortingFilteringRowsRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableBaseRenderer
extends SortingFilteringRowsRenderer {
    public static final String ROW_CLASS_KEY = "rowClass";
    public static final String BREAK_ROW_BEFORE = "breakRowBefore";
    public static final String COLUMN_CLASS = "userColumnClass";
    public static final String ROW_CLASS = "userRowClass";
    protected static final String FIRST_ROW_CLASS_KEY = "firstRowClass";
    protected static final String CELL_CLASS_KEY = "cellClass";
    private static final String CELL_ELEMENT_KEY = "cellElement";

    public void encodeColumn(FacesContext context, ResponseWriter writer, UIColumn component, RowHolder rowHolder) throws IOException {
        Map attributes;
        String parentId = rowHolder.getParentClientId();
        if (component instanceof AbstractColumn && Boolean.TRUE.equals((attributes = component.getAttributes()).get(BREAK_ROW_BEFORE)) && rowHolder.getProcessCell() != 0) {
            this.encodeRowEnd(writer);
            rowHolder.nextRow();
            rowHolder.setRowStart(true);
        }
        if (rowHolder.isRowStart()) {
            int currentRow = rowHolder.getCurrentRow();
            String[] rowClasses = this.getRowClasses(rowHolder);
            if (rowClasses.length > 0) {
                int indeStyleClass = currentRow % rowClasses.length;
                String rowClass = rowClasses[indeStyleClass];
                component.getAttributes().put(ROW_CLASS, rowClass);
            }
            if (rowHolder.getCurrentRow() == 0) {
                this.encodeFirstRowStart(writer, context, parentId, currentRow, (UIComponent)component);
            } else {
                this.encodeRowStart(writer, context, parentId, currentRow, (UIComponent)component);
            }
            if (rowHolder.getRow() instanceof UIDataTableBase) {
                this.renderRowHandlers(context, (UIDataTableBase)rowHolder.getRow());
            }
            rowHolder.setRowStart(false);
        }
        this.encodeColumnStart(writer, context, parentId, (UIComponent)component);
        this.renderChildren(context, (UIComponent)component);
        this.encodeColumnEnd(writer, context, parentId);
        rowHolder.nextCell();
    }

    public void encodeColumnStart(ResponseWriter writer, FacesContext context, String parentId, UIComponent component) throws IOException {
        writer.startElement(this.getCellElement(context, parentId), component);
        writer.writeAttribute("id", (Object)component.getContainerClientId(context), "id");
        String cellClass = this.getCellClass(context, parentId);
        cellClass = this.concatClasses(cellClass, component.getAttributes().get(COLUMN_CLASS));
        this.encodeStyleClass(writer, context, component, "styleClass", cellClass);
        this.encodeStyle(writer, context, component, null);
        if (component instanceof AbstractColumn) {
            Integer colspan;
            Map attributes = component.getAttributes();
            Integer rowspan = (Integer)attributes.get("rowspan");
            if (rowspan != null && rowspan != Integer.MIN_VALUE) {
                writer.writeAttribute("rowspan", (Object)rowspan, null);
            }
            if ((colspan = (Integer)attributes.get("colspan")) != null && colspan != Integer.MIN_VALUE) {
                writer.writeAttribute("colspan", (Object)colspan, null);
            }
        }
    }

    public void encodeColumnEnd(ResponseWriter writer, FacesContext context, String parentId) throws IOException {
        writer.endElement(this.getCellElement(context, parentId));
    }

    public void encodeFirstRowStart(ResponseWriter writer, FacesContext context, String parentId, int currentRow, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        writer.writeAttribute("id", (Object)(parentId + ":" + currentRow), null);
        String styleClass = this.concatClasses(this.getRowClass(context, parentId), this.getFirstRowClass(context, parentId), component.getAttributes().get(ROW_CLASS));
        if (styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
    }

    public void encodeFirstRowEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    public void encodeRowStart(ResponseWriter writer, FacesContext context, String parentId, int currentRow, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        writer.writeAttribute("id", (Object)(parentId + ":" + currentRow), null);
        String styleClass = this.concatClasses(this.getRowClass(context, parentId), component.getAttributes().get(ROW_CLASS));
        if (styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
    }

    public void encodeRowEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    protected String getFirstRowClass(FacesContext context, String id) {
        return this.get(context, id + FIRST_ROW_CLASS_KEY);
    }

    protected String getRowClass(FacesContext context, String id) {
        return this.get(context, id + ROW_CLASS_KEY);
    }

    protected String getCellClass(FacesContext context, String id) {
        return this.get(context, id + CELL_CLASS_KEY);
    }

    protected String getCellElement(FacesContext context, String id) {
        String elementName = this.get(context, id + CELL_ELEMENT_KEY);
        if (elementName == null) {
            elementName = "td";
        }
        return elementName;
    }

    protected void setCellElement(FacesContext context, String id, String element) {
        this.put(context, id + CELL_ELEMENT_KEY, element);
    }

    protected void saveRowStyles(FacesContext context, String id, String firstRowClass, String rowClass, String cellClass) {
        this.put(context, id + FIRST_ROW_CLASS_KEY, firstRowClass);
        this.put(context, id + ROW_CLASS_KEY, rowClass);
        this.put(context, id + CELL_CLASS_KEY, cellClass);
    }

    public void encodeStyleClass(ResponseWriter writer, FacesContext context, UIComponent component, String styleClassAttribute, String styleClass) throws IOException {
        boolean isEmpty = this.isEmptyAttr(component, styleClassAttribute);
        if (isEmpty && (styleClass == null || styleClass.trim().length() == 0)) {
            return;
        }
        String componentStyleClass = isEmpty ? styleClass : styleClass + " " + component.getAttributes().get(styleClassAttribute);
        writer.writeAttribute("class", (Object)componentStyleClass, null);
    }

    protected boolean isEmptyAttr(UIComponent component, String attribute) {
        if (attribute == null) {
            return true;
        }
        String value = (String)component.getAttributes().get(attribute);
        return value == null || value.trim().length() == 0;
    }

    protected void encodeStyle(ResponseWriter writer, FacesContext context, UIComponent component, String predefinedStyles) throws IOException {
        String style;
        StringBuffer toEncode = new StringBuffer();
        if (!this.isEmptyAttr(component, "style")) {
            style = ((String)component.getAttributes().get("style")).trim();
            style = style.endsWith(";") ? style : style + ";";
            toEncode.append(style);
        }
        if (!this.isEmpty(predefinedStyles)) {
            style = predefinedStyles.endsWith(";") ? predefinedStyles : predefinedStyles + ";";
            toEncode.append(style);
        }
        if (toEncode.length() > 0) {
            writer.writeAttribute("style", (Object)toEncode.toString(), null);
        }
    }

    protected boolean isEmpty(String style) {
        return style == null || style.trim().length() == 0;
    }

    protected int getColumnsCount(Iterator<UIComponent> col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent component = col.next();
            if (!component.isRendered()) continue;
            if (component instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.getColumnsCount(((Row)component).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (component instanceof AbstractColumn) {
                Integer colspan;
                Map attributes = component.getAttributes();
                if (Boolean.TRUE.equals(attributes.get(BREAK_ROW_BEFORE))) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)attributes.get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(component instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    @Override
    public void encodeFakeRow(FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
        UIComponent component = (UIComponent)rowHolder.getRow();
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("tr", component);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.startElement("td", component);
        writer.endElement("td");
        writer.endElement("tr");
    }
}

