/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.PushContextFactory;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;

public abstract class TopicsContext {
    private ConcurrentMap<String, Topic> topics = new ConcurrentHashMap<String, Topic>();

    protected abstract Topic createTopic(TopicKey var1);

    public Topic getOrCreateTopic(TopicKey key) {
        Topic result = (Topic)this.topics.get(key.getTopicName());
        if (result == null) {
            Topic newTopic = this.createTopic(key);
            result = this.topics.putIfAbsent(key.getTopicName(), newTopic);
            if (result == null) {
                result = newTopic;
            }
        }
        return result;
    }

    public Topic getTopic(TopicKey key) {
        return (Topic)this.topics.get(key.getTopicName());
    }

    public void removeTopic(TopicKey key) {
        this.topics.remove(key.getTopicName());
    }

    public void publish(TopicKey key, Object data) throws MessageException {
        Topic topic = this.getTopic(key);
        if (topic == null) {
            throw new MessageException(MessageFormat.format("Topic {0} not found", key.getTopicName()));
        }
        topic.publish(key, data);
    }

    public static TopicsContext lookup() {
        return ServiceTracker.getService(PushContextFactory.class).getPushContext().getTopicsContext();
    }
}

