/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractDataScroller;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.1.0.20110910-M2"})
public class UIDataScroller extends AbstractDataScroller
        {

    public static final String COMPONENT_TYPE="org.richfaces.DataScroller";

    public static final String COMPONENT_FAMILY="org.richfaces.DataScroller";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIDataScroller() {
        super();
        setRendererType("org.richfaces.DataScrollerRenderer");
    }




    protected enum Properties {
        boundaryControls,
        fastControls,
        fastStep,
        lastPageMode,
        maxPages,
        render,
        renderIfSinglePage,
        stepControls
        
    }

 
    public DataScrollerControlsMode getBoundaryControls() {
        DataScrollerControlsMode value = (DataScrollerControlsMode) getStateHelper().eval(Properties.boundaryControls);
        return value;
    }
    
    public void setBoundaryControls(DataScrollerControlsMode boundaryControls) {
        getStateHelper().put(Properties.boundaryControls, boundaryControls);
    }

 
    public DataScrollerControlsMode getFastControls() {
        DataScrollerControlsMode value = (DataScrollerControlsMode) getStateHelper().eval(Properties.fastControls);
        return value;
    }
    
    public void setFastControls(DataScrollerControlsMode fastControls) {
        getStateHelper().put(Properties.fastControls, fastControls);
    }

 
    public int getFastStep() {
        Integer value = (Integer) getStateHelper().eval(Properties.fastStep, Integer.MIN_VALUE);
        return value;
    }
    
    public void setFastStep(int fastStep) {
        getStateHelper().put(Properties.fastStep, fastStep);
    }

 
    public String getLastPageMode() {
        String value = (String) getStateHelper().eval(Properties.lastPageMode);
        return value;
    }
    
    public void setLastPageMode(String lastPageMode) {
        getStateHelper().put(Properties.lastPageMode, lastPageMode);
    }

 
    public int getMaxPages() {
        Integer value = (Integer) getStateHelper().eval(Properties.maxPages, Integer.MIN_VALUE);
        return value;
    }
    
    public void setMaxPages(int maxPages) {
        getStateHelper().put(Properties.maxPages, maxPages);
    }

 
    public Object getRender() {
        Object value = (Object) getStateHelper().eval(Properties.render);
        return value;
    }
    
    public void setRender(Object render) {
        getStateHelper().put(Properties.render, render);
    }

 
    public boolean isRenderIfSinglePage() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.renderIfSinglePage, true);
        return value;
    }
    
    public void setRenderIfSinglePage(boolean renderIfSinglePage) {
        getStateHelper().put(Properties.renderIfSinglePage, renderIfSinglePage);
    }

 
    public DataScrollerControlsMode getStepControls() {
        DataScrollerControlsMode value = (DataScrollerControlsMode) getStateHelper().eval(Properties.stepControls);
        return value;
    }
    
    public void setStepControls(DataScrollerControlsMode stepControls) {
        getStateHelper().put(Properties.stepControls, stepControls);
    }

    

    public UIComponent getLast() {
        return getFacet("last");
    }
    public void setLast(UIComponent facet) {
        getFacets().put("last", facet);
    }

    public UIComponent getPrevious() {
        return getFacet("previous");
    }
    public void setPrevious(UIComponent facet) {
        getFacets().put("previous", facet);
    }

    public UIComponent getFastForward() {
        return getFacet("fastForward");
    }
    public void setFastForward(UIComponent facet) {
        getFacets().put("fastForward", facet);
    }

    public UIComponent getNext() {
        return getFacet("next");
    }
    public void setNext(UIComponent facet) {
        getFacets().put("next", facet);
    }

    public UIComponent getFastRewind() {
        return getFacet("fastRewind");
    }
    public void setFastRewind(UIComponent facet) {
        getFacets().put("fastRewind", facet);
    }


}