package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.PushRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;


@ResourceDependencies({@ResourceDependency(name="jsf.js",library="javax.faces",target=""),@ResourceDependency(name="jquery.js",library="",target=""),@ResourceDependency(name="richfaces.js",library="",target=""),@ResourceDependency(name="richfaces-event.js",library="",target=""),@ResourceDependency(name="richfaces-base-component.js",library="",target=""),@ResourceDependency(name="jquery-atmosphere.js",library="net.java.dev.atmosphere",target=""),@ResourceDependency(name="push.js",library="org.richfaces",target="")})
public class PushRenderer extends PushRendererBase {
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH5 = attributes()
	     .generic("address","address")
	     

	     .generic("ondataavailable","ondataavailable","dataavailable")
	     

	     .generic("onerror","onerror","error")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean isEmpty(Object object) 
 {
		return object == null || object.toString().length() == 0;
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("span", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


	if (convertToBoolean(this.shouldEncodePushUrl(facesContext))) {
	{
	Object text = "RichFaces.Push.setPushResourceUrl(\"" + convertToString(this.getPushResourceUrl(facesContext)) + "\");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	Object pushHandlerUrl  =  this.getPushHandlerUrl(facesContext); 
		if ((!isEmpty(pushHandlerUrl))) {
	{
	Object text = "RichFaces.Push.setPushHandlerUrl(\"" + convertToString(pushHandlerUrl) + "\");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

}
}
Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH5, null);

{
	Object text = "new RichFaces.ui.Push(" + convertToString(toScriptArgs(clientId,options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
responseWriter.endElement("span"); 

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

