/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.renderkit.html.LibraryScriptFunction;
import org.richfaces.renderkit.html.ValidatorScriptBase;
import org.richfaces.resource.ResourceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOnlyScript
extends ValidatorScriptBase {
    public static final ResourceKey CSV_RESOURCE = ResourceKey.create((String)"csv.reslib", (String)"org.richfaces");
    protected final LibraryScriptFunction converter;
    protected final ImmutableList<? extends LibraryScriptFunction> validators;
    private final ImmutableSet<ResourceKey> resources;

    public ClientOnlyScript(LibraryScriptFunction clientSideConverterScript, Collection<? extends LibraryScriptFunction> validatorScripts) {
        this.converter = clientSideConverterScript;
        this.validators = ImmutableList.copyOf(validatorScripts);
        LinkedHashSet resources = Sets.newLinkedHashSet();
        resources.add(CSV_RESOURCE);
        if (null != this.converter) {
            Iterables.addAll((Collection)resources, this.converter.getResources());
        }
        for (LibraryScriptFunction scriptString : this.validators) {
            Iterables.addAll((Collection)resources, scriptString.getResources());
        }
        this.resources = ImmutableSet.copyOf((Collection)resources);
    }

    public Iterable<ResourceKey> getResources() {
        return this.resources;
    }

    public void appendFunctionName(Appendable target) throws IOException {
        target.append("window").append(".").append(super.getName()).append("=").append("function");
    }

    @Override
    protected void appendParameters(Appendable target) throws IOException {
        if (null != this.converter) {
            target.append("c").append(":");
            this.appendConverter(target, this.converter);
            target.append(",");
        }
        target.append("v").append(":[");
        UnmodifiableIterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            LibraryScriptFunction validatorScript = (LibraryScriptFunction)iterator.next();
            this.appendValidator(target, validatorScript);
            if (!iterator.hasNext()) continue;
            target.append(",");
        }
        target.append("]");
        this.appendAjaxParameter(target);
    }

    protected void appendValidator(Appendable target, LibraryScriptFunction validatorScript) throws IOException {
        this.appendConverter(target, validatorScript);
    }

    protected void appendConverter(Appendable target, LibraryScriptFunction converter) throws IOException {
        target.append("{").append("f").append(":").append(converter.getName()).append(",");
        target.append("p").append(":");
        ScriptUtils.appendScript((Appendable)target, converter.getParameters());
        target.append(",");
        target.append("m").append(":");
        ScriptUtils.appendScript((Appendable)target, (Object)converter.getMessage());
        target.append("}");
    }

    protected void appendAjaxParameter(Appendable target) throws IOException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        result = 31 * result + (this.validators == null ? 0 : this.validators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientOnlyScript other = (ClientOnlyScript)obj;
        if (this.converter == null ? other.converter != null : !this.converter.equals(other.converter)) {
            return false;
        }
        return !(this.validators == null ? other.validators != null : !this.validators.equals(other.validators));
    }
}

