/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSObject;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItemInterface;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.FormUtil;
import org.richfaces.renderkit.util.HandlersChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="togglePanel.js")})
public class TogglePanelRenderer
extends DivPanelRenderer
implements MetaComponentRenderer {
    public static final String VALUE_POSTFIX = "-value";
    protected static final String ITEM_CHANGE = "itemchange";
    protected static final String BEFORE_ITEM_CHANGE = "beforeitemchange";
    private static final String ON = "on";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(TogglePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
            if (this.isSubmitted(context, panel)) {
                PartialViewContext pvc = context.getPartialViewContext();
                pvc.getRenderIds().add(component.getClientId(context) + '@' + "activeItem");
            }
        }
    }

    protected boolean isSubmitted(FacesContext context, AbstractTogglePanel panel) {
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        return parameterMap.get(panel.getClientId(context)) != null;
    }

    protected static void addOnCompleteParam(FacesContext context, String newValue, String panelId) {
        StringBuilder onComplete = new StringBuilder();
        onComplete.append("RichFaces.$('").append(panelId).append("').onCompleteHandler('").append(newValue).append("');");
        ExtendedPartialViewContext.getInstance((FacesContext)context).appendOncomplete((Object)onComplete.toString());
    }

    static String getValueRequestParamName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + VALUE_POSTFIX;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        FormUtil.throwEnclFormReqExceptionIfNeed(context, component);
        super.doEncodeBegin(writer, context, component);
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("name", (Object)TogglePanelRenderer.getValueRequestParamName(context, component), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)panel.getActiveItem(), null);
        writer.endElement("input");
        this.writeJavaScript(writer, context, component);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tgp", TogglePanelRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanel", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("cycledSwitching", panel.isCycledSwitching());
        options.put("ajax", (Object)TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, ITEM_CHANGE);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, BEFORE_ITEM_CHANGE);
        return options;
    }

    public static void addEventOption(FacesContext context, UIComponent component, Map<String, Object> options, String eventName) {
        HandlersChain handlersChain = new HandlersChain(context, component);
        handlersChain.addInlineHandlerFromAttribute(ON + eventName);
        handlersChain.addBehaviors(eventName);
        String handler = handlersChain.toScript();
        if (handler != null) {
            options.put(ON + eventName, new JSFunctionDefinition(new Object[]{JSReference.EVENT}).addToBody((Object)handler));
        }
    }

    public static AjaxOptions getAjaxOptions(FacesContext context, UIComponent panel) {
        return AjaxRendererUtils.buildEventOptions(context, panel);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanel.class;
    }

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("activeItem".equals(metaComponentId)) {
            AbstractTogglePanel panel = (AbstractTogglePanel)component;
            AbstractTogglePanelItemInterface item = panel.getItem(panel.getActiveItem());
            if (item != null) {
                this.partialStart(context, ((UIComponent)item).getClientId(context));
                ((UIComponent)item).encodeAll(context);
                this.partialEnd(context);
                TogglePanelRenderer.addOnCompleteParam(context, item.getName(), panel.getClientId(context));
            } else {
                this.partialStart(context, component.getClientId(context));
                component.encodeAll(context);
                this.partialEnd(context);
                TogglePanelRenderer.addOnCompleteParam(context, panel.getActiveItem(), panel.getClientId(context));
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }

    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
    }

    protected void partialStart(FacesContext facesContext, String id) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(id);
    }

    protected void partialEnd(FacesContext facesContext) throws IOException {
        facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
    }
}

