/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.lang.annotation.Annotation;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.richfaces.validator.BeanValidatorFactory;
import org.richfaces.validator.InitializationException;
import org.richfaces.validator.MessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichFacesBeanValidatorFactory
implements BeanValidatorFactory {
    private ValidatorFactory validatorFactory;
    private ValidatorContext validatorContext;

    public RichFacesBeanValidatorFactory() {
        ValidatorFactory.class.getName();
    }

    public void init() throws InitializationException {
        try {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
            this.validatorContext = this.validatorFactory.usingContext();
            JsfMessageInterpolator jsfMessageInterpolator = new JsfMessageInterpolator(this.validatorFactory.getMessageInterpolator());
            this.validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
        }
        catch (ValidationException e) {
            throw new InitializationException(e);
        }
    }

    public Validator getValidator(FacesContext context) {
        return this.validatorContext.getValidator();
    }

    public FacesMessage interpolateMessage(FacesContext context, final ConstraintDescriptor<? extends Annotation> constrain) {
        if (constrain.getAttributes().containsKey("message")) {
            Object object = constrain.getAttributes().get("message");
            String interpolatedMessage = this.validatorFactory.getMessageInterpolator().interpolate(object.toString(), new MessageInterpolator.Context(){

                public Object getValidatedValue() {
                    return "{0}";
                }

                public ConstraintDescriptor<?> getConstraintDescriptor() {
                    return constrain;
                }
            }, MessageFactory.getCurrentLocale(context));
            return new FacesMessage(interpolatedMessage);
        }
        return MessageFactory.createMessage(context, "javax.faces.component.UIInput.UPDATE");
    }

    private static final class JsfMessageInterpolator
    implements MessageInterpolator {
        private MessageInterpolator delegate;

        public JsfMessageInterpolator(MessageInterpolator delegate) {
            this.delegate = delegate;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            Locale locale = MessageFactory.getCurrentLocale(FacesContext.getCurrentInstance());
            if (null != locale) {
                return this.delegate.interpolate(messageTemplate, context, locale);
            }
            return this.delegate.interpolate(messageTemplate, context);
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            Locale faceslocale = MessageFactory.getCurrentLocale(FacesContext.getCurrentInstance());
            if (null != faceslocale) {
                return this.delegate.interpolate(messageTemplate, context, faceslocale);
            }
            return this.delegate.interpolate(messageTemplate, context, locale);
        }
    }
}

