/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util.base64;

import java.io.ByteArrayOutputStream;
import java.util.BitSet;
import org.ajax4jsf.util.base64.BinaryDecoder;
import org.ajax4jsf.util.base64.BinaryEncoder;
import org.ajax4jsf.util.base64.DecoderException;
import org.ajax4jsf.util.base64.EncoderException;

public class URLCodec
implements BinaryEncoder,
BinaryDecoder {
    protected static final byte ESCAPE_CHAR = 37;
    protected static final BitSet WWW_FORM_URL;

    public static final byte[] encodeUrl(byte[] bytes) {
        return URLCodec.encodeUrl(WWW_FORM_URL, bytes);
    }

    public static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (urlsafe.get(b)) {
                if (b == 32) {
                    b = 43;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return buffer.toByteArray();
    }

    public static final byte[] decodeUrl(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37) {
                try {
                    int u = Character.digit((char)bytes[++i], 16);
                    int l = Character.digit((char)bytes[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new DecoderException("Invalid URL encoding");
                    }
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid URL encoding");
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    public byte[] encode(byte[] bytes) {
        return URLCodec.encodeUrl(WWW_FORM_URL, bytes);
    }

    public byte[] decode(byte[] bytes) throws DecoderException {
        return URLCodec.decodeUrl(bytes);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.encode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.encode((String)pObject);
        }
        throw new EncoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL encoded");
    }

    public Object decode(Object pObject) throws DecoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.decode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.decode((String)pObject);
        }
        throw new DecoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL decoded");
    }

    static {
        int i;
        WWW_FORM_URL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            WWW_FORM_URL.set(i);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }
}

