/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.el.CapturingELResolver;
import org.richfaces.el.ELContextWrapper;
import org.richfaces.el.GenericsIntrospectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsIntrospectionServiceImpl
implements GenericsIntrospectionService {
    private final Map<Class<?>, GenericsCacheEntry> cache = new MapMaker().weakKeys().softValues().makeComputingMap(new Function<Class<?>, GenericsCacheEntry>(){

        public GenericsCacheEntry apply(Class<?> input) {
            return new GenericsCacheEntry(input);
        }
    });

    private Class<?> getGenericCollectionType(FacesContext context, Object base, String propertyName) {
        Class<?> beanClass;
        Class<?> genericPropertyClass = null;
        if (base != null && propertyName != null && !Map.class.isAssignableFrom(beanClass = base.getClass()) && !ResourceBundle.class.isAssignableFrom(beanClass)) {
            return this.cache.get(beanClass).getContainerClass(propertyName);
        }
        return genericPropertyClass;
    }

    public Class<?> getContainerClass(FacesContext facesContext, ValueExpression expression) {
        CapturingELResolver capturingELResolver;
        ELContext initialELContext = facesContext.getELContext();
        Class type = expression.getType((ELContext)new ELContextWrapper(initialELContext, (ELResolver)(capturingELResolver = new CapturingELResolver(initialELContext.getELResolver()))));
        Class<?> containerType = type.getComponentType();
        if (containerType == null && type != null && Collection.class.isAssignableFrom(type)) {
            Object base = capturingELResolver.getBase();
            Object property = capturingELResolver.getProperty();
            if (base != null && property != null) {
                containerType = this.getGenericCollectionType(facesContext, base, property.toString());
            }
        }
        return containerType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GenericsCacheEntry {
        private Class<?> beanClass;
        private Map<String, Class<?>> containerClassesMap = new MapMaker().initialCapacity(2).makeComputingMap(new Function<String, Class<?>>(){

            public Class<?> apply(String input) {
                PropertyDescriptor propertyDescriptor = GenericsCacheEntry.this.getPropertyDescriptor(input);
                return GenericsCacheEntry.this.getGenericContainerClass(propertyDescriptor);
            }
        });

        public GenericsCacheEntry(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        private Class<?> resolveType(Type type) {
            Type actualType;
            ParameterizedType parameterizedType;
            Type[] types;
            Class result = Object.class;
            if (type instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()) != null && types.length != 0 && (actualType = types[0]) instanceof Class) {
                result = (Class)actualType;
            }
            return result;
        }

        private Class<?> getGenericContainerClass(PropertyDescriptor pd) {
            if (pd == null) {
                return null;
            }
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) {
                return null;
            }
            return this.resolveType(readMethod.getGenericReturnType());
        }

        private PropertyDescriptor getPropertyDescriptor(String propertyName) {
            PropertyDescriptor[] propertyDescriptorsArray;
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(this.beanClass);
            }
            catch (IntrospectionException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            finally {
                Introspector.flushFromCaches(this.beanClass);
            }
            if (beanInfo == null) {
                return null;
            }
            for (PropertyDescriptor pd : propertyDescriptorsArray = beanInfo.getPropertyDescriptors()) {
                if (!propertyName.equals(pd.getName())) continue;
                return pd;
            }
            return null;
        }

        public Class<?> getContainerClass(String propertyName) {
            return this.containerClassesMap.get(propertyName);
        }
    }
}

